/*****************************************************************************
*
*  cc3000_common  - CC3000 Host Driver Implementation.
*  Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*****************************************************************************/

#include "cc3000_common.h"
#include "NVIC_set_all_priorities.h"
#include "wlan.h"

//*****************************************************************************
//                  CC3000 I/O setup and control
//*****************************************************************************

WLAN_IRQ_PIN_CREATE;
WLAN_EN_PIN_CREATE;
WLAN_CS_PIN_CREATE;
WLAN_SPI_PORT_CREATE;


void Init_HostDriver(void)
{
    NVIC_ALL_IRQ;
    NVIC_SPI_IRQ;
    NVIC_PORT_IRQ;
    NVIC_SYSTICK_IRQ;
//    NVIC_ADC_IRQ;
    // Clear pending interrupt
    WLAN_ISF_PCR  |= PORT_PCR_ISF_MASK;
    WLAN_ISF_ISFR |= WLAN_ISF_MASK;
    //Initial state for wlan module : EN = 0 (disabled) and CS = 1 (not selected).
    WLAN_DEASSERT_EN;
    WLAN_DEASSERT_CS;

    WLAN_SPI_PORT_INIT;
    WLAN_SPI_SET_FREQ;
    WLAN_SPI_SET_IRQ_HANDLER;
//    WLAN_DISABLE_IRQ;
    // WLAN On API Implementation
    wlan_init( CC3000_UsynchCallback,
               sendWLFWPatch,
               sendDriverPatch,
               sendBootLoaderPatch,
               ReadWlanInterruptPin,
               WlanInterruptEnable,
               WlanInterruptDisable,
               WriteWlanPin);
}


char *sendDriverPatch(unsigned long *Length)
{
    *Length = 0;
    return NULL;
}


char *sendBootLoaderPatch(unsigned long *Length)
{
    *Length = 0;
    return NULL;
}


char *sendWLFWPatch(unsigned long *Length)
{
    *Length = 0;
    return NULL;
}


long ReadWlanInterruptPin(void)
{
    return (WLAN_READ_IRQ);
}

void WlanInterruptEnable()
{
    WLAN_ENABLE_IRQ;
    if(!WLAN_READ_IRQ)
        WLAN_IRQHandler();
    //NVIC_EnableIRQ(_irq_port);
}

void WlanInterruptDisable()
{
    WLAN_DISABLE_IRQ;
}


void WriteWlanPin( unsigned char val )
{
    if (val)
    {
            WLAN_ASSERT_EN;
    }
    else
    {
            WLAN_DEASSERT_EN;
    }
}


//*****************************************************************************
//                  STREAMS
//*****************************************************************************

/**
* stub function for ASSERT macro
* @param  pcFilename - file name, where error occurred
* @param  ulLine     - line number, where error occurred
* @return none
*/
void __error__(char *pcFilename, unsigned long ulLine)
{
    //TODO: create function
}


unsigned char* UINT32_TO_STREAM_f (unsigned char *p, unsigned long u32)
{
    *(p)++ = (unsigned char)(u32);
    *(p)++ = (unsigned char)((u32) >> 8);
    *(p)++ = (unsigned char)((u32) >> 16);
    *(p)++ = (unsigned char)((u32) >> 24);
    return p;
}


unsigned char* UINT16_TO_STREAM_f (unsigned char *p, unsigned short u16)
{
    *(p)++ = (unsigned char)(u16);
    *(p)++ = (unsigned char)((u16) >> 8);
    return p;
}


unsigned short STREAM_TO_UINT16_f(char* p, unsigned short offset)
{
        return (unsigned short)((unsigned short)((unsigned short)
               (*(p + offset + 1)) << 8) + (unsigned short)(*(p + offset)));
}


unsigned long STREAM_TO_UINT32_f(char* p, unsigned short offset)
{
        return (unsigned long)((unsigned long)((unsigned long)
               (*(p + offset + 3)) << 24) + (unsigned long)((unsigned long)
               (*(p + offset + 2)) << 16) + (unsigned long)((unsigned long)
               (*(p + offset + 1)) << 8) + (unsigned long)(*(p + offset)));
}




