/*****************************************************************************
*
*  netapp  - CC3000 Host Driver Implementation.
*  Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*****************************************************************************/

#include "netapp.h"

long netapp_config_mac_adrress(unsigned char * mac)
{
    return  nvmem_set_mac_address(mac);
}


long netapp_dhcp(unsigned long *aucIP, unsigned long *aucSubnetMask,unsigned long *aucDefaultGateway, unsigned long *aucDNSServer)
{
    signed char scRet;
    unsigned char *ptr;
    unsigned char *args;
    
    scRet = EFAIL;
    ptr = tSLInformation.pucTxCommandBuffer;
    args = (ptr + HEADERS_SIZE_CMD);
    
    // Fill in temporary command buffer
    ARRAY_TO_STREAM(args,aucIP,4);
    ARRAY_TO_STREAM(args,aucSubnetMask,4);
    ARRAY_TO_STREAM(args,aucDefaultGateway,4);
    args = UINT32_TO_STREAM(args, 0);
    ARRAY_TO_STREAM(args,aucDNSServer,4);
    
    // Initiate a HCI command
    hci_command_send(HCI_NETAPP_DHCP, ptr, NETAPP_DHCP_PARAMS_LEN);
    
    // Wait for command complete event
    SimpleLinkWaitEvent(HCI_NETAPP_DHCP, &scRet);
    
    return(scRet);
}


#ifndef CC3000_TINY_DRIVER
long netapp_timeout_values(unsigned long *aucDHCP, unsigned long *aucARP,unsigned long *aucKeepalive,    unsigned long *aucInactivity)
{
    signed char scRet;
    unsigned char *ptr;
    unsigned char *args;
    
    scRet = EFAIL;
    ptr = tSLInformation.pucTxCommandBuffer;
    args = (ptr + HEADERS_SIZE_CMD);
    
    // Set minimal values of timers 
    MIN_TIMER_SET(*aucDHCP)
    MIN_TIMER_SET(*aucARP)
    MIN_TIMER_SET(*aucKeepalive)
    MIN_TIMER_SET(*aucInactivity)
                    
    // Fill in temporary command buffer
    args = UINT32_TO_STREAM(args, *aucDHCP);
    args = UINT32_TO_STREAM(args, *aucARP);
    args = UINT32_TO_STREAM(args, *aucKeepalive);
    args = UINT32_TO_STREAM(args, *aucInactivity);
    
    // Initiate a HCI command
    hci_command_send(HCI_NETAPP_SET_TIMERS, ptr, NETAPP_SET_TIMER_PARAMS_LEN);
    
    // Wait for command complete event
    SimpleLinkWaitEvent(HCI_NETAPP_SET_TIMERS, &scRet);
    
    return(scRet);
}
#endif


#ifndef CC3000_TINY_DRIVER
long netapp_ping_send(unsigned long *ip, unsigned long ulPingAttempts, unsigned long ulPingSize, unsigned long ulPingTimeout)
{
    signed char scRet;
    unsigned char *ptr, *args;
    
    scRet = EFAIL;
    ptr = tSLInformation.pucTxCommandBuffer;
    args = (ptr + HEADERS_SIZE_CMD);
    
    // Fill in temporary command buffer
    args = UINT32_TO_STREAM(args, *ip);
    args = UINT32_TO_STREAM(args, ulPingAttempts);
    args = UINT32_TO_STREAM(args, ulPingSize);
    args = UINT32_TO_STREAM(args, ulPingTimeout);
    
    // Initiate a HCI command
    hci_command_send(HCI_NETAPP_PING_SEND, ptr, NETAPP_PING_SEND_PARAMS_LEN);
    
    // Wait for command complete event
    SimpleLinkWaitEvent(HCI_NETAPP_PING_SEND, &scRet);
    
    return(scRet);
}
#endif


#ifndef CC3000_TINY_DRIVER
void netapp_ping_report()
{
    unsigned char *ptr;
    signed char scRet;
    ptr = tSLInformation.pucTxCommandBuffer;
    
    
    scRet = EFAIL;
    
    // Initiate a HCI command
    hci_command_send(HCI_NETAPP_PING_REPORT, ptr, 0);
    
    // Wait for command complete event
    SimpleLinkWaitEvent(HCI_NETAPP_PING_REPORT, &scRet); 
}
#endif


#ifndef CC3000_TINY_DRIVER
long netapp_ping_stop()
{
    signed char scRet;
    unsigned char *ptr;
    
    scRet = EFAIL;
    ptr = tSLInformation.pucTxCommandBuffer;
    
    // Initiate a HCI command
    hci_command_send(HCI_NETAPP_PING_STOP, ptr, 0);
    
    // Wait for command complete event
    SimpleLinkWaitEvent(HCI_NETAPP_PING_STOP, &scRet);
    
    return(scRet);
}
#endif


#ifndef CC3000_TINY_DRIVER
void netapp_ipconfig( tNetappIpconfigRetArgs * ipconfig )
{
    unsigned char *ptr;
    
    ptr = tSLInformation.pucTxCommandBuffer;
    
    // Initiate a HCI command
    hci_command_send(HCI_NETAPP_IPCONFIG, ptr, 0);
    
    // Wait for command complete event
    SimpleLinkWaitEvent(HCI_NETAPP_IPCONFIG, ipconfig );
    
}
#else
void netapp_ipconfig( tNetappIpconfigRetArgs * ipconfig )
{

}
#endif


#ifndef CC3000_TINY_DRIVER
long netapp_arp_flush(void)
{
    signed char scRet;
    unsigned char *ptr;
    
    scRet = EFAIL;
    ptr = tSLInformation.pucTxCommandBuffer;
    
    // Initiate a HCI command
    hci_command_send(HCI_NETAPP_ARP_FLUSH, ptr, 0);
    
    // Wait for command complete event
    SimpleLinkWaitEvent(HCI_NETAPP_ARP_FLUSH, &scRet);
    
    return(scRet);
}
#endif






