// Print messages when the AnalogIn is greater than 50%
 
#include "mbed.h"
#include "arm_math.h"
#include "arm_const_structs.h"





const int FFT_LEN   = 32;
const int bins      = 64;


const static arm_cfft_instance_f32 *S;

float samples[FFT_LEN*2]={0.74749772289107352,-0.6620341598054913,2.5810074680698305,2.0375690829541551,0.85501630972362808,2.4491971123982741,0.96898486707269238,0.071615312869874215,4.135489449279282,2.8204892200482625,
1.004264658763629,1.0598806981968543,1.3924726256823439,1.1527769317445544,0.16468389119249338,-0.27422782796214529,1.8047039643381464,0.79038862751269323,-0.44495813830147357,0.53068869150488007,
1.3484439163009583,1.4200129154057697,0.88845273294643168,1.8349129948395904,1.0701928581879496,0.90708728254350102,2.4103567463264239,2.6309595238537535,2.5569927393322835,-0.58523807239622561,
-0.51517227902319718,0.69679202690936726,1.2722062355241623,0.15100625736779782,-1.6440964183517333,-1.7653834312280656,-0.70269258104390242,1.142109051997795,1.9091357377458946,0.86960141090930632,
0.96627954013362549,1.7838151901061594,2.0938256426948465,2.4378461326556282,2.2612077719971997,0.153796332301813,2.4901349915557365,2.4431403321019047,-0.35438693729683535,2.8433009646491154,
0.51019781464390002,0.42022358860095488,0.2968374005289679,2.4566906658298451,0.33088401348465118,2.3551821216079407,0.9486742272689056,1.3010822355769571,1.4433689356494175,0.88483024478861216,
0.60929525861200262,2.8294626914715204,1.9228669058909631,0.9947297034997874};
float magnitudes[FFT_LEN];
float freq_window[bins];
Serial     pc(USBTX, USBRX);

int main() 
{   
    pc.baud(115200);
    int32_t i = 0;
    printf("\r\n\r\nFFT test program!\r\n");
    printf("by Curtis Mattull\r\n\r\n\r\n");


        // Init arm_ccft_32
    switch (FFT_LEN)
    {
    case 16:
        S = & arm_cfft_sR_f32_len16;
        break;
    case 32:
        S = & arm_cfft_sR_f32_len32;
        break;
    case 64:
        S = & arm_cfft_sR_f32_len64;
        break;
    case 128:
        S = & arm_cfft_sR_f32_len128;
        break;
    case 256:
        S = & arm_cfft_sR_f32_len256;
        break;
    case 512:
        S = & arm_cfft_sR_f32_len512;
        break;
    case 1024:
        S = & arm_cfft_sR_f32_len1024;
        break;
    case 2048:
        S = & arm_cfft_sR_f32_len2048;
        break;
    case 4096:
        S = & arm_cfft_sR_f32_len4096;
        break;
    }

    /*populate some dummy sin data*/
    //for(i = 0; i< FFT_LEN*2; i+=2)
    //{
        //fast math sine table[512+1]
        //samples[i]      = sinTable_f32[i/4];
        //samples[i+1]    = 0;
    //}
    
    /*multiply the dummy data with more dummy data*/
//    for(i = 0; i< FFT_LEN*2; i+=2)
//    {
//        //fast math sine table[512+1]
//        samples[i]     +=sinTable_f32[i/2] ;
//        samples[i+1]    = 0;
//    }
    
    // Run FFT on sample data.
    arm_cfft_f32(S, samples, 0, 1);
    // Calculate magnitude of complex numbers output by the FFT.
    arm_cmplx_mag_f32(samples, magnitudes, FFT_LEN);
    
    printf("\r\nThe first 20 bins:\r\n");
    
    for(i = 0; i< 40; i++)
    {
        printf("magnitudes[%i]: %f\r\n",i,magnitudes[i]);
    }
    
    //led_g.write(led_on);

    printf("test complete\r\n");
    wait(1);
    while(1) 
    {
        
    }
}