 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    WDT\RESET\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the WDT Reset example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use WDT to generate chip reset after a specific time.
	Process:
		WDT setting:
			- generate reset chip when WDT times out.
			- time-out = 5s
			- clock source: IRC (Internal RC oscillator)
		After start, WDT counter decrease until underflow (5s) to generate a chip reset.
		If between 5s, RESET button is pressed, chip force an external reset.
		If not, WDT will reset chip after 5s automatically.
		After reset, the program will determine what cause of last reset time (external 
		reset or WDT Timeout reset) 
		
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files
	  
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	wdt_reset_test.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
	Serial display configuration: (e.g: TeraTerm, Hyperterminal, Flash Magic...) 
		 115200bps 
		 8 data bit 
		 No parity 
		 1 stop bit 
		 No flow control 
	
	Running mode:
		RAM mode:   This example can be run on RAM mode with debugger. 
					All files must be build to .elf file, this file will be loaded into RAM through a 
					debugger tool before running 
		ROM(FLASH)mode: This example can be run on ROM mode with debugger or standalone after burning. 
					All files in each example must be built to .hex file. This file will be burned into 
					ROM(Flash) memory through an external tool (i.e: Flash Magic...) befor running.
					
					Note: If want to burn hex file to board by using Flash Magic, these jumpers need
					to be connected:
					- MCB1700 with LPC1768 ver.1:
						+ RST: ON
						+ ISP: ON
					- IAR LPC1768 KickStart vers.A:
						+ RST_E: ON
						+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Connect UART0 on this board to COM port on your computer
		- Step 4: Configure hardware and serial display as above instruction 
		- Step 5: Run example and observe data on serial display
					+ If in between 5s, hit RESET button, after reset, we will have the notice
						" Last MCU reset caused by External!"
					+ If not, WDT cause chip reset and after reset, we will have the notice
						" Last MCU reset caused by WDT TimeOut!"
						
		(Pls see "LPC17xx Example Description" document - chapter "Examples > WDT > RESET"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil
	