 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    TIMER\Gen_Diff_Freqs\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the TIMER Match example in generating
 *			2 different frequency signals.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use Timer Match to generate 2 different
		frequency signals.
	Process:
		1) Initialize UART0 and display information menu.
		2) Ask user to input frequency for channel1 (MAT0.0) and channel2 (MAT2.0)
		   Configure P1.28 as MAT0.0, P0.6 as MAT2.0.
		3) Configure TIMER0 and TIMER2 as follow:
			- Prescale register = 1 us.
			- Match register = 1 / ((channel1 or channel2 frequency)*100us*2)
							 = 500000 / channel1 or channel2 freuqency
			- No interrupt, no stop but reset timer counter on match.
		4) Start TIMER0 and TIMER2.
		   Press ESC if we intend to test with other frequencies.
		   TIMER0 and TIMER2 are de-initialized.

@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	 
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	gen_diff_freqs.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
	Serial display configuration: (e.g: TeraTerm, Hyperterminal, Flash Magic...) 
		 115200bps 
		 8 data bit 
		 No parity 
		 1 stop bit 
		 No flow control 
	
	Running mode:
		RAM mode:   ...TBD
		ROM(FLASH)mode: This example can be run on ROM mode with debugger or standalone after burning. 
					All files in each example must be built to .hex file. This file will be burned into 
					ROM(Flash) memory through an external tool (i.e: Flash Magic...) befor running.
					
					Note: If want to burn hex file to board by using Flash Magic, these jumpers need
					to be connected:
					- MCB1700 with LPC1768 ver.1:
						+ RST: ON
						+ ISP: ON
					- IAR LPC1768 KickStart vers.A:
						+ RST_E: ON
						+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Connect UART0 on this board to COM port on your computer
		- Step 4: Configure hardware and serial display as above instruction 
		- Step 5: Run example and observe MAT0.0 and MAT2.0 waveform by oscilloscope.
		(Pls see "LPC17xx Example Description" document - chapter "Examples > TIMER > Gen_Diff_Freqs"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil