 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    PWR\EXTINT_Sleep\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the EXTINT Sleep example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to enter system in sleep mode and wake-up by using
		external interrupt
	Process:
		It has some difference about testing on MCB1700 and IAR1700 board:
		- MCB1700:
			+ LEDs: LED1 - P1.28
					LED2 - P1.29
			+ EXTINT: use external interrupt 0
			+ INT button: INT0
		- IAR1700:
			+ LEDs: LED1 - P1.25
					LED2 - P0.4
			+ EXTINT: use external interrupt 2
			+ INT button: WAKE-UP
		First LED will be blinked in normal mode. And when receive '1' character from serial
		display, the system call 'CLKPWR_Sleep()' function to enter sleep mode. 
		Then, when press INT button to to generate external interrupt, it will wake-up system
		and blink second LED.
					
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	 
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	extint_sleep.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested only on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- INT0: ON
				- LED: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- ACC_IRQ/LED2: 2-3 (LED2)
				- Remain jumpers: OFF
				
		Serial display configuration:(e.g: TeraTerm, Hyperterminal, Flash Magic...) 
			 115200bps 
			 8 data bit 
			 No parity 
			 1 stop bit 
			 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Connect UART0 on this board to COM port on your computer
		- Step 4: Configure hardware and serial display as above instruction 
		- Step 5: Run example and observe result on serial display
				+ Hit RESET button to run example
				+ Press '1' to enter sleep mode
				+ Press INT button:
					- MCB1700: INT0 button
					- IAR1700: WAKE-UP button
				  to wake-up the system 
			
		(Pls see "LPC17xx Example Description" document - chapter "Examples > PWR > EXTINT_Sleep"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil