 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    LCD\NOKIA6610_LCD\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the LCD NOKIA6610 example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use LCD NOKIA6610 on IAR-LPC1768-KS board
	Process:
		This example use LCD NOKIA6610 driver library that deriverd from IAR.
		Using SPI protocol to communicate with LCD controller chip.
		It starts by show NXP icon.
		LCD operation can be controlled by using:
			- AN_TRIM: ADC potentiometer - increase/decrease LCD backlight or contrast. 
			- BUT1: used to adjust backlight.
			- BUT2: used to adjust LCD contrast.		
			
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	drv_glcd_cbcf.h: Graphic LCD configuration file
	drv_glcd.h/.c: Graphic LCD driver
	glcd_ll.h/.c: Graphic LCD low level functions
	lcdtest.c: Main program
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	NXP_logo.h/.c: NXP icon data
	Terminal_9_12x6: font (12x6) data
	makefile: Example's makefile (to build with GNU toolchain)
	

@How to run:
	Hardware configuration:		
		This example was tested only on:
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF

	Running mode:
		This example can run only on ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Configure hardware as above instruction
		- Step 4: Hit reset button to run example:
					+ It shows NXP icon first.
					+ Hit "BUT1" if want to adjust backlight, then turn ADC potentiometer AN_TRIM to 
					  change LCD backlight.
					+ Hit "BUT2" if want to adjust contrast, then turn ADC potentiometer AN_TRIM to 
					  change LCD contrast.
					  
		(Pls see "LPC17xx Example Description" document - chapter "Examples > LCD > NOKIA6610_LCD"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil		