 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    GPIO\LedBlinky\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the GPIO LedBlinky example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		A simple program to test GPIO interrupt functionality to drive LED		
	Process:
		Keil MCB1700 with LPC1768:		
		After reset software all LED from P1.28 to P2.6 will be blinking one after another	
		IAR LPC1768 KickStart:		
		After reset software LED1 will be blinking

@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile
	LedBlinky.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDREGS: ON 
				- VBUS: ON
				- LED: ON
				- INT0: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Choose correct working board: In LEDBlinky.c file
			+ If using MCB1700 board, setting:
				#define MCB_LPC_1768	
				//#define IAR_LPC_1768	
			+ If using IAR-LPC1768-KS board, setting:
				//#define MCB_LPC_1768	
				#define IAR_LPC_1768	
			(Should not enable/disable both symbols at the same time)	
		- Step 2: Build example.
		- Step 3: Burn hex file into board (if run on ROM mode)
		- Step 4: Reset the board then we can see the LED blinking
		
		(Pls see "LPC17xx Example Description" document - chapter "Examples > GPIO > LEDBlinky"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil
