 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    Cortex-M3\Privilege_mode\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the Privilege mode example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to change privilege to unprivilege mode and vice vesa.
	Process:
		CONTROL[0] register controls the privilege level for software execution when the 
		processor is in Thread mode. So, we can access to get/set CONTROL[0] to change Thread
		mode privilege level.
		
		Out of reset, Thread mode is privilege.
		Read CONTROL[0] to check if it is truly privilege or not.
		If Thread mode is not privilege, so it's not compliant with Cortex-M3 Technical, the 
		program will enter into infinite error loop.
		Then, set CONTROL[0] = 1, changing Thread mode to unprivilege.
		Re-check by re-read CONTROL[0] again.
		A system service will be call __SCV(). In this exception mode, we can switch back Thread 
		mode into privilege 
		(Note that:
			When Thread mode has been changed from privilege to use, it cannot change ifself back 
			to privilege. Only a handler can change the privilege of Thread mode.
			Handler mode is always privilege.
		)
		After call handler, get CONTROL[0] to check if it is truly privilege or not.
		If not, program will enter to error loop.
		
		We use two LED to display status of Thread mode.
		LED1: turn on if Thread mode is privilege.
		LED2: turn on if Thread mode is unprivilege.
		- Using MCB1700 board: LED1 is P1.28, LED2 is P1.29
		- Using IAR1700 board: LED1 is P1.25, LED2 is P0.4
					
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	priviledge.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested only on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- LED: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- ACC_IRQ/LED2: 2-3 (LED2)
				- Remain jumpers: OFF
				
		Serial display configuration:(e.g: TeraTerm, Hyperterminal, Flash Magic...) 
			 115200bps 
			 8 data bit 
			 No parity 
			 1 stop bit 
			 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Connect UART0 on this board to COM port on your computer
		- Step 4: Configure hardware and serial display as above instruction 
		- Step 5: Run example and observe on serial display
					+ Press '1' to change into unprivilege mode
					+ Press '2' to switch back to privilege mode
			
		(Pls see "LPC17xx Example Description" document - chapter "Examples > Cortex-M3 > Privilege_mode"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil