 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    ADC\HardwareTrigger\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the ADC hardware-trigger example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use ADC conversion in hardware-triggered mode.
	Process:
		The ADC conversion rate is 200KHz. A fully A fully accurate conversion requires 65 of these clocks. 
		So ADC clock = 200KHz * 65 = 13MHz.
		Note that maximum ADC clock input is 13MHz.  
		
		When INT0 falling adge occurs, ADC will start converting.
		ADC will generate interrupt at the end of each conversion. ADC service routine will be invoked 
		to check ADC status, if "DONE bit" is set, ADC converted data will be stored in "adc_value".
		ADC interrupt is disabled and re-enabled for the next conversion.
		ADC converted data are displayed via UART0.
		
		Turn potentiometer to change ADC signal input.

@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	adc_hardware_trigger_test.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- AD0.2: ON
				- INT0: ON
				- Remain jumpers: OFF
				
	Serial display configuration: (e.g: TeraTerm, Hyperterminal, Flash Magic...) 
		 115200bps 
		 8 data bit 
		 No parity 
		 1 stop bit 
		 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Connect UART0 on this board to COM port on your computer
		- Step 4: Configure hardware and serial display as above instruction 
		- Step 5: Run example
				  Press INT0 button to start the ADC conversion
				  Tune potetiometer and press INT0 button again then observe data on serial display
		
		(Pls see "LPC17xx Example Description" document - chapter "Examples > ADC > HardwareTrigger"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil