 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    I2C\sc16is750_polling\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the I2C SC16IS750 Polling example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		An example of I2C using polling mode to test the I2C driver.
		Using I2C at mode I2C master/8bit on LPC1768 to communicate with
		SC16IS750/760 Demo Board.
	Process:
		I2C is configured as master using polling mode.
		I2C Clock Rate is set at 100K.
				
		I2C send commands to reset, config direction, validate value and handle SC16IS740 chip 
		using polling mode.
		On serial display:
		- Press 'r' to print menu
		- Press '1': send 0x00 value to IOStat register to turn on 8 LEDs on SC16IS740 board.
		- Press '2': send 0xFF value to IOStat register to turn off 8 LEDs on SC16IS740 board.
		
		(Pls see two pdf file at SPI/sc16is750:
			- SC16IS740_750_760_6.pdf
			- schematics.sc16is750.demo.board.pdf
		for more information about SC16IS740 board) 
		
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	i2c_polling_test.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
			SC16IS750 board:
			 	These jumpers must be configured as following:
			 	- JP2: 1-2 (I2C)
			 	- JP16: 2-3 (hard reset)
			 	- Remain jumper: OFF
			 	
	I2C connection:
			- SDA and SCL pin in two board connect in "pin-to-pin" style: SDA <-> SDA, SCL <-> SCKss 
			- Common power source 3.3V and ground must be connected together between two board.	
		+ For I2C0:
			SDA: P0.27
			SCL: P0.28
		+ For I2C2:
			SDA: P0.10	
			SCL: P0.11	
				
	Serial display configuration:(e.g: TeraTerm, Hyperterminal, Flash Magic...) 
		 115200bps 
		 8 data bit 
		 No parity 
		 1 stop bit 
		 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
						
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Choose I2C peripheral by setting 'USEDI2CDEV'
		- Step 2: Build example.
		- Step 3: Burn hex file into board (if run on ROM mode)
		- Step 4: Connect UART0 on this board to COM port on your computer
		- Step 5: Configure hardware and serial display as above instruction 
		- Step 6: Run example, and control the I2C transmition and reception via UART display tool.
		
		(Pls see "LPC17xx Example Description" document - chapter "Examples > I2C > sc16is750_polling"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil
