 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    Cortex-M3\Bit-banding\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the Bit-banding example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to test Bit-banding feature of Cortex-M3 processor
	Process:
		The processor memory map includes two bit-band regions. These occupy the lowest
		1MB of the SRAM and peripheral memory regions respectively.
		+ SRAM: 	Bit-band region: 	0x20000000 - 0x20100000
					Bit-band alias:		0x22000000 - 0x23FFFFFF
		+ PERI:		Bit-band region:	0x40000000 - 0x40100000
					Bit-band alias:		0x42000000 - 0x43FFFFFF
		The mapping formula:
				bit_word_offset = (byte_offset * 32) + (bit_number * 4)
				bit_word_address = bit_band_base + bit_word_offset
		where:
		+ bit_word_offset: the position of the target bit in the bit-band memory region
		+ bit_word_addr: the address of the word in the alias memory region that maps to the target bit
		+ bit_band_base: the starting address of the alias region
		+ byte_offset: the number of byte in the bit-band region that contains the targeted bit
		+ bit_number: is the bit position (0-7) of the targeted bit
		
		Note: In fact, the SRAM on LPC1768 just available in two ranges:
					+ 0x2007C000 - 0x2007FFFF: for SRAM  bank 0
					+ 0x20080000  0x20083FFF: for SRAM  bank 1
			  So, just can set 'VAR_ADDR' with value that exits in two ranges SRAM above.
		Beside, the range: 0x2009C000 - 0x2009FFF is assigned for GPIO peripheral.
		So you can use VAR_ADDR in this range for bit-modifying GPIO registers.
		
		First, the program test SRAM bit-banding:
			+ read the value at VAR_ADDRESS
			Using bit-band access to:
			+ read the value at 'VAR_BIT'.
			+ clear the value at 'VAR_BIT' and print new value at VAR_ADDRESS 
			+ re-set the value at 'VAR_BIT' and print new value at VAR_ADDRESS
		Then, the program test PERIPHERAL bit-banding:
		In this case, use SPCR register for testing
			+ Assigned value SPCR: 0x00000A28
			Use bit-band access to:
			+ read the value at 'PERI_BIT'
			+ clear the value at 'PERI_BIT' and print new value of SPCR 
			+ re-set the value at 'PERI_BIT' and print new value of SPCR
					
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	bitband.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested only on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
		Serial display configuration:(e.g: TeraTerm, Hyperterminal, Flash Magic...) 
			 115200bps 
			 8 data bit 
			 No parity 
			 1 stop bit 
			 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Connect UART0 on this board to COM port on your computer
		- Step 4: Configure hardware and serial display as above instruction 
		- Step 5: Run example and observe result on serial display
			
		(Pls see "LPC17xx Example Description" document - chapter "Examples > Cortex-M3 > Bit-Banding"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil