 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    ADC\Burst\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the ADC burst (single or multiple input) example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use ADC conversion in burst mode with single or multiple input.
		This example also describes how to inject an ADC conversion channel while the others are running.
	Process:
		Because the potentiometer on different board connect to different ADC channel, so we have to configure correct 
		ADC channel on each board respectively. In this case, 
			- If using MCB1700 board: ADC is configured to convert signal on channel 2
			- If using IAR-LPC1768-KS board: ADC is configured to convert signal on channel 5
		The ADC conversion rate is 200KHz. A fully A fully accurate conversion requires 65 of these clocks. 
		So ADC clock = 200KHz * 65 = 13MHz.
		Note that maximum ADC clock input is 13MHz.  
		
		Burst ADC will repeatedly sample-convert the voltage on ADC0.x pin(s) then update the channel data register(s).
		So we just need to read the ADC channel data register(s) and display the value via UART0. 
		
		Turn potentiometer to change ADC signal input.
		
		Only in burst mode, ADC can sample multiple channels, then we can inject by configuring this mode.
		This example uses GPIO interrupt on P2.10 to trigger the injection, and uses P1.28 to toggle the LED
		indicating that an ADC channel has just been injected or removed.

@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	adc_burst_test.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- AD0.2: ON
				- Remain jumpers: OFF

			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
		ADC configure:
			*For multiple inputs:
				- The ADCx sample pin must not left floating, otherwise,
				the readout value of these pins will same as the value 
				of the pin which connected to a real voltage.
				- This example uses an addition ADCx pin: AD0.3 (P0.26).
				Make sure the SPK jumper is OFF.
				- Try to make an external 10K, 3 pins vari-resistor,
				1 terminal connects to 3.3V or Vrefp, the other connects to GND,
				and the rest (middle pin) connects to P0.26 
			*For injection test:
				- LED jumper need to be ON to blinking LED P1.28.					
				
	Serial display configuration: (e.g: TeraTerm, Hyperterminal, Flash Magic...) 
		 115200bps 
		 8 data bit 
		 No parity 
		 1 stop bit 
		 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Choose correct working board by uncomment correct defined board in adc_burst_test.c file
			+ If using MCB1700 board, uncomment "#define MCB_LPC_1768"
				If test multiple input, then uncomment "#define MCB_LPC_1768_ADC_BURST_MULTI"
				If test injection, then uncomment:
					+ "#define MCB_LPC_1768_ADC_BURST_MULTI"
					+ "#define MCB_LPC17XX_ADC_INJECT_TEST"
			+ If using IAR-LPC1768-KS board, uncomment "#define MCB_LPC_1768"
			(Should not uncomment both symbols at the same time)
		- Step 2: Build example.
		- Step 3: Burn hex file into board (if run on ROM mode)
		- Step 4: Connect UART0 on this board to COM port on your computer
		- Step 5: Configure hardware and serial display as above instruction 
		- Step 6: Run example, turn potetiometer and observe data on serial display
				  *For injection test:
				  	- Press the INT0 button (on MCB1700 board) to see the state of LED P1.28:
				  		+ ON: ADC channel 3 has just been inserted.
				  		+ OFF: ADC channel 3 has just been removed.
				  	- Look at the PC's terminal application screen, associate with the state of LED P1.28:
				  		+ ON: the ADC channel 3 value is continuosly updated.
				  		+ OFF: the ADC channel 3 value is unchanged, keep its last updated value.
		
		(Pls see "LPC17xx Example Description" document - chapter "Examples > ADC > Burst"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil