 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    USBDEV\USBAudio\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the USBDEV Audio example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use USBDEV on LPC1768 to demo the USB Audio Device - Speaker.
	Process:		                                                   
		Clock Settings:
		   - XTAL                   =  12 MHz
		   - PLL                    =  400 MHz
		   - processor clock = CCLK =  100 MHz
		   - USB clock              =  48 MHz
		   - CCLK / 4 clock         =  25 MHz
	The USB Audio Device is recognized by the host PC running
	Windows which will load a generic Audio driver and add a
	speaker which can be used for sound playback on the PC.
	Potenciometer on the board is used for setting the Volume.	
		     		
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	adcuser.h/.c: Audio Device Class Custom User Module
	audio.h: USB Audio Device Class Definitions
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	usb.h:  USB Definitions
	usbaudio.h: USB Audio Demo Definitions
	usbcfg.h: USB Custom Configuration
	usbcore.h/.c: USB Core Module
	usbdesc.h/.c: USB Descriptors
	usbdmain.c: main program	
	usbhw.h/.c: SB Hardware Layer Module
	usbreg.h: USB Hardware Layer Definitions for NXP Semiconductors LPC 
	usbuser.h/.c: USB Custom User Module
	makefile: Example's makefile (to build with GNU toolchain)

@How to run:
	Hardware configuration:		
		This example was tested only on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- D+: DEVICE
				- D-: DEVICE
				- UMODE: 1-2 (USB)
				- E/U: 1-2 (USB)
				- SPK: ON
				- AD0.2: ON
				- Remain jumpers: OFF
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Configure hardware as above instruction 
		- Step 4: Hit reset button to run example. 
		- Step 5: After see UGL(USB Good Link) led on board turn on, open "Device Manager > Sound,video 
				  and game controller" to see if "USB Audio Device" appears or not. 
		- Step 6: Open "Control Panel > Sound > Audio" choose Default device is "NXP LPC17xx Speaker" 
		- Step 7: Choose Default device "NXP LPC17xx Speaker" for Voice tab
		- Step 8: Try to play a sound file (such as .mp3 file) and hear the voice from speaker on board.
		          Turn potiometer to change volume.
		
		(Pls see "LPC17xx Example Description" document - chapter "Examples > USBDEV > USBAudio"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil