 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    EMAC\Easy_Web\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the EMAC Easy web example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to implement an simple web application 
	Process:
		This tiny web server was taken from the 'Design & Elektronik'
		extra issue 'Embedded Internet'. It can be downloaded from the 
		following web site: www.elektroniknet.de/extraheft. 
		
		Note that modifications are not optimal, because ARM is a 32-bit 
		machine while the original software was written for 16-bit cpu.
		
		The web page shows the values of two analog inputs (AN0 and AN1).
		This tiny webserver needs very little resources and therefore has
		some restrictions:
		- only one active TCP session at any one time
		- no support for fragmented IP datagrams
		- no buffer for TCP datagrams received in wrong order
		- only one web page. No GIF/JPG graphics possible.
		
		The IP address can be modified in the module tcpip.h to
		fit into your existing LAN (see MYIP_x). 
		The default IP address is: 192.168.0.100
		Please order the extra issue 'Embedded Internet' of the 
		'Design & Elektronik' magazine for a technical description.
		It is only available in German language.
			
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	ADC.h/.c: ADC low level functions
	easyweb.c/.h: easy web application (Main program)
	EMAC.h/.c: LPC1768 EMAC hardware driver functions
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	Retarget.c: target-dependent low level functions
	tcpip.h/.c: implement TCP/IP stack functions	
	makefile: Example's makefile (to build with GNU toolchain)
	webpage.h: webpage html source
	
@How to run:
	Hardware configuration:	
		This example is tested on:	
			Keil MCB1700 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON
				- VBUS: ON
				- LED: ON
				- E/C: 2-3 (Ethernet)
				- E/U: 2-3 (Ethernet)
				- Remain jumpers: OFF
				Use Ethernet Physical Layer Transceiver: DP83848C 
				MAC address: 1E-30-6C-A2-45-5E 
			IAR LPC1768 vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depending of power source
				- DBG_EN : ON
				- ACC_IRQ/LED2: 2-3 (LED2)
				- Remain jumpers: OFF
				Use Ethernet Physical Layer Transceiver: FSZ8721BL 
				MAC address: 0-FF-FF-FF-FF-FF
				
		Serial display configuration: (e.g: TeraTerm, Hyperterminal, Flash Magic...) 
			 115200bps 
			 8 data bit 
			 No parity 
			 1 stop bit 
			 No flow control 
	
	Running mode:
		This example can run only on ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Choose correct working board by uncomment correct defined board in lpc17xx_emac.h file
			+ If using MCB1700 board, uncomment "#define MCB_LPC_1768"
			+ If using IAR-LPC1768-KS board, uncomment "#define MCB_LPC_1768"
			(Should not uncomment both symbols at the same time)
		- Step 2: Build example.
		- Step 3: Burn hex file into board.
		- Step 4: Use CrossOver cable to connect from your PC to ETH port on eval board
		- Step 5: Connect UART0 on this board to COM port on your computer
		- Step 6: Configure hardware and serial display as above instruction 
		- Step 7: Re-config IP address on PC:
					+ IP address: 192.168.0.x (x != 100)
					+ Subnet mask: 255.255.255.0
		- Step 8: Reset board, monitor the status via serial display until EMAC initialized
		- Step 9: Open command prompt window, execute 'ping 192.168.0.100' command
		- Step 10: Open web browser, access to address "http://192.168.0.100" to display the content
		           of webserver. Turn potentiometer and see the update ADC value on this web
		           		
		(Pls reference "LPC17xx Example Description" document - chapter "Examples > EMAC > Easy_Web"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil	
	
			