 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    Cortex-M3\MPU\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the MPU example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use MPU to protect memory region.
	Process:
		Use MPU to set up 8 memory regions as follows:
		  Region 0 - Privileged code: 0x00000000 - 0x0007FFFF(512kB)
		  Region 1 - Privileged data: 0x10000000 - 0x10007FFF(32kB)
		  Region 2 - APB Peripheral:  0x40000000 - 0x400FFFFF(1MB)
		  Region 3 - AHB peripheral:  0x50000000 - 0x501FFFFF(2MB)
		  Region 4 - System control:  0xE0000000 - 0xE00FFFFF(1MB)
		  Region 5 - On-chip SRAM:    0x2007C000 - 0x2007FFFF(16kB)
		  Region 6 - Private SRAM:    0x20080000 - 0x20083FFF(16kB)
		  Region 7 - GPIO peripheral: 0x2009C000 - 0x2009FFFF(16Kb)
		Except region 6 can not access, remain regions can access normally.
		After setup:
		- First, we try to access memory at address: 0x10000000 -> it will allow to access
		- Last, we try to access memory at address: 0x20080000 -> it will not allow to access
		At the time we access to memory that disallow, Memory Management Handler will be invoked
		and we blink LED P1.28 to announce.
					
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	mpu_test.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested only on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
		Serial display configuration:(e.g: TeraTerm, Hyperterminal, Flash Magic...) 
			 115200bps 
			 8 data bit 
			 No parity 
			 1 stop bit 
			 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Connect UART0 on this board to COM port on your computer
		- Step 4: Configure hardware and serial display as above instruction 
		- Step 5: Run example
			- Press '1' to access memory in region 1
			- Press '2' to access memory in region 6
			See LED P1.28 blink
			
		(Pls see "LPC17xx Example Description" document - chapter "Examples > Cortex-M3 > MPU"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil