 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    UART\UART1_FullModem\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the UART1_FullModem example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This is a simple UART example using UART1 will Full modem mode
	Process:
		Uart pin configuration:
			- If using MCB1700 eval board, assign pin P2.0 - P2.7 for UART1
		 	- If using IAR 1768 KS board, assign pin P0.7 - P0.15 for UART2
	 	Configure UART using the following settings:
	 		- Baudrate = 9600bps
	 		- 8 data bit
	 		- 1 Stop bit
	 		- None parity

		After reset UART will send the welcome massage then start to receive the 
		character from PC and send back that character to PC.
		
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	 
	lpc17xx_libcfg.h: Library configuration file - include needed driver library 
			for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	uart_fullmodem_test.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- AD0.2: ON
				- LED: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
							
		UART FullModem connection
				Because eval board does not wire all pins of UART1 to the COM1 port,
				the signal on CTS, RTS might be in incorrect state for UART1 running.
				In this case, CTS pin must be pulled-low	
					+ MCB board: CTS pin is P2.2
					+ IAR board: CTS pin is P0.17
					
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 
		"Creating and working with LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Connect UART1 on this board to COM port on your computer
		- Step 5: Run example and using Serial display to see the result.
		
		(Pls see "LPC17xx Example Description" document - chapter "Examples > UART > UART1_FullModem"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil
