 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    SSP\sc16is750_polling\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the SSP SC16IS750 Polling example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use SSP in polling mode to communicate 
		with SC16IS750/760 Demo Board.
	Process:
		SSP configuration:
			- CPHA = 0: data is sampled on the first clock edge of SCK.
			- CPOL = 0: SCK is active high
			- Clock rate = 1MHz
			- DSS = 8: 8 bits per transfer
			- MSTR = 1: SSP operates in Master mode
			- FRF= 0: SPI Frame format
		SSP send commands to reset, config direction and handle SC16IS740 chip in polling mode.
		On serial display:
		- Press 'r' to print menu
		- Press '1': send 0x00 value to IOStat register to turn on 8 LEDs on SC16IS740 board.
		- Press '2': send 0xFF value to IOStat register to turn off 8 LEDs on SC16IS740 board.
		
		(Pls see two pdf file at SPI\sc16is750_int:
			- SC16IS740_750_760_6.pdf
			- schematics.sc16is750.demo.board.pdf
		for more information about SC16IS740 board)

@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files
	 
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	sc16is750_polling.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
		SC16IS750 board:
			 	These jumpers must be configured as following:
			 	- JP2: 2-3 (SPI)
			 	- JP16: 2-3 (hard reset)
			 	- Remain jumper: OFF
			
		SPI connection:
			- P0.15 - SCK on eval board connects to SCLK on SC16IS750 board
	 		- P0.16 - SSEL on eval board connects to /CS on SC16IS750 board (used as GPIO)
	  		- P0.17 - MISO on eval board connects to MISO on SC16IS750 board
	  		- P0.18 - MOSI on eval board connects to MOSI on SC16IS750 board
			Common power source 3.3V and ground must be connected together between two board.
	  			
	Serial display configuration: (e.g: TeraTerm, Hyperterminal, Flash Magic...) 
		 115200bps 
		 8 data bit 
		 No parity 
		 1 stop bit 
		 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode) 
		- Step 5: Connect UART0 on board to COM port on your computer
		- Step 6: Configure hardware, connect this board with SC16IS750 board as above instruction 
		- Step 7: Configure serial display as above instruction
		- Step 8: Run example and handle SSP transfer via serial display
				+ Press '1' to turn on 8 LEDs on SC16IS750 board
				+ Press '2' to turn off 8 LEDs on SC16IS750 board
				
		(Pls see "LPC17xx Example Description" document - chapter "Examples > SSP > sc16is750_polling" 
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil