 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    QEI\QEI_Velo\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the QEI Velocity calculation example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use Quadrature Encoder Interface module to
		calculate velocity
	Process:
		This is just a simple QEI demo for demonstrate QEI operation on LPC17xx

		This example use a timer match interrupt to generate a virtual QEI signal output for QEI 
		module to capture (Phase A and Phase B channel). In case of using QEI virtual signal, 
		symbol VIRTUAL_QEI_SIGNAL must be set to 1. In this case, two GPIO output pin on port 0 
		can be used	to toggle state that defined through PHASE_A_PIN and PHASE_B_PIN. The MCFB0 
		(PHA - Phase A input) and MCFB1 (PHB - Phase B input) therefore must be connect to these GPIO pins.
		
		In this case, a 'virtual encoder' that has these following parameter:
 			- Encoder type			: Quadrature encoder
			- Max velocity			: MAX_VEL (Round Per Minute)
 			- Encoder Resolution	: ENC_RES (Pulse Per Round)
 		The calculated frequency is: Freq = (MAX_VEL * ENC_RES * COUNT_MODE) / 60 (Hz)
 		The timer therefore should be set to tick every cycle T = 1/Freq (second)		

@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	 
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	qei_test_velo.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
	
		QEI configuration:
			Use P0.19 and P0.21 to generate virtual signal supply for QEI peripheral by using timer 
			match interrupt output.
			Connect: - P0.19 to P1.20 (MCI0)
					 - P0.21 to P1.23 (MCI1)
				
	Serial display configuration:(e.g: TeraTerm, Hyperterminal, Flash Magic...) 
		 115200bps 
		 8 data bit 
		 No parity 
		 1 stop bit 
		 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Connect UART0 on this board to COM port on your computer
		- Step 4: Configure hardware and serial display as above instruction 
		- Step 5: Run example and observe data on serial display
		
		(Pls see "LPC17xx Example Description" document - chapter "Examples > QEI > QEI_Velo"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil
	