 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    I2C\pc8581_polling\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the I2C PCA8581 example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use I2C to communicate with EEPROM PCA8581
	Process:
		I2C is configured as master using polling mode to send/receive data.
		I2C Clock Rate is set at 200K.
		PCA8581 Slave address is 0xA0 (8-bit format)
		After initialize and enable I2C, I2C writes 8 data to PCA8581 at address: (0x01<<3)
		by using 'PCA8581_Write( )'function and then read back again these data from PCA8581.
		After transmittion finished, read and write buffer will be compared, if not 
		familiar, the program will display an error message.
		(Please see 'PCA8581.pdf' for more information about EEPROM PCA8581) 
		 				
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	pca8581_polling.c: Main program
	PCA8581.pdf: PCA8581's datasheet file

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
	
	I2C pin selection:
		For I2C0:
			- SDA -> P0.27
			- SCL -> P0.28
		For I2C1:
			- SDA -> P0.10
			- SCL -> P0.11			
				
	EEPROM PCA8581 connection:
		- A0, A1 and A2 - Pin 1, 2, 3: must be connect with GND
		- SCL - Pin 6: connects with SCL pin of I2C peripheral on board
		- SDA - Pin 5: connects with SDA pin of I2C peripheral on board
		- VDD - Pin 8: supply voltage, connects to 5V power source
		- Vss - Pin 4: connect to GND on board
		- TEST - Pin 7: not used	
				
	Serial display configuration:(e.g: TeraTerm, Hyperterminal, Flash Magic...) 
		 115200bps 
		 8 data bit 
		 No parity 
		 1 stop bit 
		 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Choose I2C peripheral by setting 'USEDI2CDEV'
		- Step 2: Build example.
		- Step 3: Burn hex file into board (if run on ROM mode)
		- Step 4: Connect PCA8581 and configure serial display as above instruction
		- Step 5: Connect UART0 on this board to COM port on your computer
		- Step 6: Run example, and control the I2C transmition result on UART display tool.
		
		(Pls see "LPC17xx Example Description" document - chapter "Examples > I2C > pca8581_polling"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil
