 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    GPDMA\GPDMA_Sleep\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the GPDMA Sleep example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to test GPDMA operation in sleep mode
	Process:
		GPDMA perpiheral in LPC17xx can operate in Sleep mode.
		Note that: in Sleep mode, the GPDMA can not access the flash memory.
		At first, source and destinate buffers were initialized.
		After that, GPDMA channel 0 is initialized as follows:
			+ Channel: 0
			+ Transfer size: 0x100
			+ Source address: DMA_SRC = LPC_AHBRAM1_BASE = 0x20080000
			+ Destination address: DMA_DST = DMA_SRC+DMA_SIZE = 0x20080100
			+ Transfer width = WORD
			+ Transfer type: M2M (memory-to-memory)
			+ No use link list
		After enable GPDMA interrupt, call "CLKPWR_Sleep()" function for entering system in sleep mode. 
		GPDMA will transfer 2 block of data from memory boundary to the other memory boundary on RAM 
		by using interrupt mode in sleep mode.
		
		After transferring completed, "Buffer_Verify()" will be called to compare data block in 
		memory source and destination. If not similar, program will enter infinite loop.
		Open serial display to observe DMA transfer process.
					
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	gpdma_sleep.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
		Serial display configuration:(e.g: TeraTerm, Hyperterminal, Flash Magic...) 
			 115200bps 
			 8 data bit 
			 No parity 
			 1 stop bit 
			 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Connect UART0 on this board to COM port on your computer
		- Step 4: Configure hardware and serial display as above instruction 
		- Step 5: Run example and observe on serial display
			
		(Pls see "LPC17xx Example Description" document - chapter "Examples > GPDMA > GPDMA_Sleep"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil