 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    DAC\WaveGenerate\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the example to generate sinewave, triangle,
 *          escalator signal by DAC.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use DMA to generate multi signal forms.
	Process:
		DAC will be initialized with maximum current is 700uA. This allows a maximum update rate of 1Mhz
		Formula for ouput voltage on AOUT is: 
			AOUT = VALUE x ((Vrefp - Vrefn)/1024)+Vrefn
		in which:
		- Vrefp: tied to VDD(3.3V)
		- Vrefn: tied to Vss
		
		DAC will generate a sinewave with peak to peak is within Vrefp and Vrefn. We need to prepare a
		look up table with 60 items, each item is the value to update AOUT voltage, and it's correspondent
		to a sample point of 1 circle sinewave signal. The formula is below:
			for(i=0;i<NUM_SAMPLE_SINE;i++) //NUM_SAMPLE_SINE = 60
			{
				dac_lut[i] = 512 + 512*sin(i);
				dac_lut[i] = (dac_sine_lut[i]<<6);
			}
		For generating triangle wave signal, the following formula is used:
			for(i=0;i<NUM_SAMPLE;i++) //NUM_SAMPLE=64
			{
				if(i<32) dac_lut[i]= 32*i;
				else if (i==32) dac_lut[i]= 1023;
				else dac_lut[i] = 32*(NUM_SAMPLE-i);
				dac_lut[i] = (dac_lut[i]<<6);
			}
			This will create a balance triangle.
		Below is the formula for escalator case:
			for(i=0;i<NUM_SAMPLE;i++) //NUM_SAMPLE=64
			{
				dac_lut[i] = (1023/3)*(i/16);
				dac_lut[i] = (dac_lut[i]<<6);
			}
			This will create an escalator with 4 steps.
			
		GPDMA channel 0 is configured in this example and used to transfer dac_lut[i] to DAC peripheral.
		When the last item of dac_lut is transfered, GPDMA will roll back to transfer the first item.
			
		DAC is configured to use time out for each DAC value update and trigger GPDMA to fill DAC value register.
		This time out value can also be used to calculate the signal frequency:
			time out = (PCLK_DAC_IN_MHZ*1000000)/(SIGNAL_FREQ_IN_HZ*NUM_SAMPLE);
			Where:	- PCLK_DAC_IN_MHZ = 25
					- SIGNAL_FREQ_IN_HZ = 60
					- NUM_SAMPLE = 60 / 64
		
		UART0 will display a menu, asks user to select the signal to generate:
			1) Sine
			2) Triangle
			3) Escalator			
		Select the signal type and observe AOUT signal by oscilloscope.
		Press ESC if you want to terminate trasmitting the currect signal type
		and generate other signal types.
					
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	 
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	dac_wave_generate.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- SPK: OFF
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
		Serial display configuration: (e.g: TeraTerm, Hyperterminal, Flash Magic...) 
			 115200bps 
			 8 data bit 
			 No parity 
			 1 stop bit 
			 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Connect UART0 on this board to COM port on your computer
		- Step 4: Configure hardware and serial display as above instruction 
		- Step 5: Run example and observe AOUT signal by oscilloscope
		
		(Pls see "LPC17xx Example Description" document - chapter "Examples > DAC > WaveGenerate"
		for more details)
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil