 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    CAN\CAN_test_two_kit\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the CAN test two kit example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to configure CAN operation in two boards seperately
	Process:
		Using 2 CAN1 peripheral on two boards to test.
		This example just supports explicit standard/extended ID format.
		Both CAN1 peripherals are set baudrate at 125KHz
		
		CAN transmit: 
			Initialize 4 CAN messages:
				- 1st message with 11-bit ID which exit in AF Look-up Table
				- 2nd message with 11-bit ID which not exit in AF Look-up Table
				- 3th Message with 29-bit ID which exit in AF Look-up Table
				- 4th Message with 29-bit ID which exit in AF Look-up Table
			These messages will be send to CAN peripheral in another board
		CAN receive: 
			Setup a simple AFLUT. It just has two sections:
				- Explicit Standard Frame Format Identifier Section
				- Explicit Extended Frame Format Identifier Section
			Receive message from another board. Whenever CAN1 receive message that has ID exit
			in its AFLUT, receive interrupt occurs, CAN service routine will be invoked to receive
			message and save its data in array "AFRxMsg[]" and print to serial display via UART0 port.
			In this case, messages 1,3 will be received.
		
		Open serial display to observe CAN transfer processing. 
			
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	can_test_two_kit.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on two board:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- Remain jumpers: OFF
				
		CAN connection:
			- Two pins CAN-Pin2 (CAN-L) must be connected between two board
			- Two pins CAN-Pin7 (CAN-H) must be connected between two board
			(Common ground must be connected together between two board)
				
		Serial display configuration: (e.g: TeraTerm, Hyperterminal, Flash Magic...) 
			 115200bps 
			 8 data bit 
			 No parity 
			 1 stop bit 
			 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
								
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Setting "CAN_TRANSMIT = 1" (in main.c file) -> build and burn hex file in the board transmitter
		- Step 2: Setting "CAN_TRANSMIT = 0" (in main.c file) -> build and burn hex file in the board receiver
		Note that: receive program also can run in RAM mode. In this case, not burn hex file but run it with debugger.
		- Step 3: Connect UART0 on board receiver to COM port on your computer
		- Step 4: Configure hardware and serial display as above instruction 
		- Step 5: Run example:
			- Re-set board receiver.
			- Re-set board transmitter.
		
		(Pls see "LPC17xx Example Description" document - chapter "Examples > CAN > CAN_test_two_kit"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil
	