 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    ADC\Polling\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the ADC Polling example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use ADC conversion in polling mode.
	Process:
		Because the potentiometer on different board connect to different ADC channel, so we have to configure correct 
		ADC channel on each board respectively. In this case, 
			- If using MCB1700 board: ADC is configured to convert signal on channel 2
			- If using IAR-LPC1768-KS board: ADC is configured to convert signal on channel 5
		DMA channel 0 was configured in this example.
		The ADC conversion rate is 200KHz. A fully A fully accurate conversion requires 65 of these clocks. 
		So ADC clock = 200KHz * 65 = 13MHz.
		Note that maximum ADC clock input is 13MHz.  
		
		After start ADC operation, polling "DONE" bit. If "DONE" bit is set, store ADC converted data in "adc_value"
		and display this data via UART0 and re-start ADC for next conversion.
				
		Turn potentiometer to change ADC signal input.

@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	adc_polling_test.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- AD0.2: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
	Serial display configuration: (e.g: TeraTerm, Hyperterminal, Flash Magic...) 
		 115200bps 
		 8 data bit 
		 No parity 
		 1 stop bit 
		 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Choose correct working board by uncomment correct defined board in adc_polling_test.c file
			+ If using MCB1700 board, uncomment "#define MCB_LPC_1768"
			+ If using IAR-LPC1768-KS board, uncomment "#define MCB_LPC_1768"
			(Should not uncomment both symbols at the same time)
		- Step 2: Build example.
		- Step 3: Burn hex file into board (if run on ROM mode)
		- Step 4: Connect UART0 on this board to COM port on your computer
		- Step 5: Configure hardware and serial display as above instruction 
		- Step 6: Run example, turn potetiometer and observe data on serial display
		
		(Pls see "LPC17xx Example Description" document - chapter "Examples > ADC > Polling"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil