 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    UART\HWFlowControl\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the UART hardware flowcontrol example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use UART in hardware flow control mode
	Process:
		UART1 configuration:
			 9600bps 
			 8 data bit 
			 No parity 
			 1 stop bit 
			 RTS/CTS flow control 
			- Receive and transmit enable
		
		UART will print welcome screen first, then:
		 	- press any key to have it read in from the terminal and returned back to the terminal.
			- Press ESC to exit.
			- Press 'r' to print welcome screen menu again.
			
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	uart_hw_flow_control.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- LED: OFF
				- Remain jumpers: OFF
				
			UART connection:
				Because COM1 port just has TXD1, RXD1, GND, so we need to make external RS232 board to 
				connect TXD1, RXD1, RTS1, CTS1, GND with PC's COM port.
				This external board is not difficult, the schematic can be found in the 232 IC datasheet,
				below is just some notes:
					- DB9 connector:
						+ pin 2: connect to 232's T2OUT.
						+ pin 3: connect to 232's R2IN
						+ pin 7: connect to 232's R1IN //RTS
						+ pin 8: connect to 232's T1OUT. //CTS
					- UART1 pin:
						+ P2.0 TXD1: connect to 232's T2IN
						+ P2.1 RXD1: connect to 232's R2OUT
						+ P2.2 CTS1: connect to 232's R1OUT
						+ P2.7 RTS1: connect to 232's T1IN			
				
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Connect external board to COM port on your computer
		- Step 4: Configure hardware and serial display as above instruction 
		- Step 5: Run example
				  Open PC terminal application, configure 
				  	- 9600bps, 
				  	- 8 databit 
				  	- no parity 
				  	- 1 stop bit 
				  	- hardware control
				  Type in some characters to see they displayed back on terminal screen.
		
		(Pls see "LPC17xx Example Description" document - chapter "Examples > UART > HWFlowControl"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil
