 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    TIMER\Interrupt_Match\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the TIMER Interrupt Match example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use Timer Match to generate specific time
		in interrupt mode.
	Process:
		In this case, the specific time generated is 1s.
		Timer configuration:
			- Timer channel: 0
			- Prescaler in microsecond value
			- prescaler value = 100us
		Match configuration:
			- Use channel 0, MR0
			- Match value = 10000
			Because timer tick = prescaler = 100us
			So match time = 100 * 10000 = 1000000us = 1s
			- Timer reset after match
			- Not stop MR0 when match
			- Toggle MR0.0 when match
			Because match time = 1s
			So MAT0.0 will be toggled at frequency = 1Hz
			- Generate match interrupt 
		Whenever MR0 matches the value in TC register, match interrupt is occurs, TIMER0
		will invoke interrupt service routine to handle interrupt, in this case, it will print 
		a notice sentence into serial display. MAT0.0(P1.28) toggle and timer will be reseted.
		
		Note that: print data via UART can cause delay when match time set is too small.

@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files
	  
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	timer_int_match.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
	Serial display configuration: (e.g: TeraTerm, Hyperterminal, Flash Magic...) 
		 115200bps 
		 8 data bit 
		 No parity 
		 1 stop bit 
		 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Connect UART0 on this board to COM port on your computer
		- Step 4: Configure hardware and serial display as above instruction 
		- Step 5: Run example and observe match interrupt notice on serial display
				+ On MCB1700 board: MAT0.0(P1.28) connect with LED P1.28, so you can observe MAT0.0 toggle via 
				LED P1.28 blinky process.
				+ On IAR board: MAT0.0 signal can be observed by oscilloscope or wire P1.28 pin with LED1(P1.25)
				
		(Pls see "LPC17xx Example Description" document - chapter "Examples > TIMER > Interrupt_Match"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil