 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    PWM\Match_Interrupt\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the MCPWM Match Interrupt example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use PWM Match function in interrupt mode.
	Process:
		This program illustrates the PWM signal on 6 Channels in single edge mode
	 	Peripheral clock for PWM: PWM_PCLK = CCLK / 4 = 72MHz/4 = 18MHz and there is no
	 	prescale for PWM. The PWM timer/counter clock is at 18MHz. The base rate is set to 256
	 	The base PWM frequency is at 18MHz/256 = 70.312 KHz (Period = ~14.22 microsecond)
	 	Each PWM channel (1 to 6) will be configured as following:
			 + PWM1.1 = (10/256) (period = 0.56 microsecond) (P2.0)
			 + PWM1.2 = (20/256) (period = 1.11 microsecond) (P2.1)
			 + PWM1.3 = (30/256) (period = 1.67 microsecond) (P2.2)
			 + PWM1.4 = (40/256) (period = 2.22 microsecond) (P2.3)
			 + PWM1.5 = (50/256) (period = 2.78 microsecond) (P2.4)
			 + PWM1.6 = (60/256) (period = 3.33 microsecond) (P2.5)
		 Using Oscilloscope to observe the PWM signals
		 Here, PWM1.1 value keeps changing, it will increase by the time from 0 to 256 period
		 and restart. Match interrupt for channel 0 is set, when timer of PWM reach to 256
		 (value of channel 0 match), an interrupt for matching will generate and update the
		 value of PWM1.1, this value will be updated every 4096 match interrupts or:
		 Period * 4096 = 14.22 * 4096 = 58,245 (microsecond)
		 And this value will be reset to 0 after:
		 Period * 4096 * 256 = 14,910,750.72 (microsecond) = ~15 (second)

@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	 
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	pwm_match_int.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- Remain jumpers: OFF
				- The output signal can be observed by oscilloscope on these pins below:
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
			PWM pin selected:
				Observe PWM wave signal on these pin
				- PWM1.1 (channel 1): P2.0
				- PWM1.2 (channel 2): P2.1
				- PWM1.3 (channel 3): P2.2
				- PWM1.4 (channel 4): P2.3
				- PWM1.5 (channel 5): P2.4
				- PWM1.6 (channel 6): P2.5
		
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Configure hardware as above instruction 
		- Step 4: Run example, Use oscilloscope to monitor the wave form 
		
		(Pls see "LPC17xx Example Description" document - chapter "Examples > PWM > Match_Interrupt"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil
