 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    I2S\I2S_DMA\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the I2S DMA example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use I2S in DMA mode
	Process:
		I2S setup:
			- wordwidth: 16 bits
			- stereo mode
			- master mode for TX and slave mode for RX
			- ws_haftword = 31
			- frequency = 44.1Khz (maximum is 96kHz)
		GPDMA channel 0 and 1 are configured in this example.
		DMA channel 0 used to transfer data from interal RAM source to I2S peripheral
		DMA channel 1 used to transfer data from I2S peripheral to internal RAM destination.
		Transfer size = 0x0a bytes
		rx_depth_dma = 8
		tx_depth_dma = 1
		So, when recieve FIFO level = 8, it triggers a receive DMA request save data from I2S to 
		destination memory.
		And when transmit FIFO level = 1, it triggers a transmit DMA request to send data from source
		memory to I2S. 
		After transmittion finised, "Buffer_Verify(void)" function will be called to compare data from 
		source and destination. If not similar, it will return FALSE.
		Open serial terminal to observe I2S transfer process.
		
		Pls note that because I2S is the protocol for audio data transfer, so sometime it has dummy data
		while FIFO transmit is empty. These data are not importance and they can be ignored when verify. 
			
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	 
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	i2s_dma_test.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
		I2S connection:
		I2S-RX connects to I2S-TX as following:
		- P0.4-I2SRX_CLK connects to P0.7-I2STX_CLK
		- P0.5-I2SRX_WS  connects to P0.8-I2STX_WS
		- P0.6-I2SRX_SDA connects to p0.9-I2STX_SDA
				
	Serial display configuration:(e.g: TeraTerm, Hyperterminal, Flash Magic...) 
		 115200bps 
		 8 data bit 
		 No parity 
		 1 stop bit 
		 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Build example.
		- Step 2: Burn hex file into board (if run on ROM mode)
		- Step 3: Connect UART0 on this board to COM port on your computer
		- Step 4: Configure hardware and serial display as above instruction 
		- Step 5: Run example, observe data on serial display 
					+ Press '1' to initialize buffer
					+ Press '2' to initialize DMA
					+ Press '3' to start I2S operation
					
		(Pls see "LPC17xx Example Description" document - chapter "Examples > I2S > I2S_DMA"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil	
	
		