 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    I2C\Monitor\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the I2C monitor mode example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use I2C to monitor traffic on I2C bus. 
	Process:
		 I2C0 is configured in monitor mode.
		 UART0 is configure for displaying captured data.
		 		
		After reset software will run the following steps: 		
		1)Display introducion menu.
		2)Ask user input the length of monitor buffer, in hex.
		3)Start capturing I2C data, when buffer length exceeded, the whole
		captured data is displayed.
		4)Roll back to step 2.
		
@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	 
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile (to build with GNU toolchain)
	i2c_monitor.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDIO: ON
				- VDDREGS: ON 
				- VBUS: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- Remain jumpers: OFF
				
		I2C connection:
			For I2C0:
				- SDA -> P0.27
				- SCL -> P0.28

		SDA, SCL connect to SDA, SCL of the I2C bus which we intend to capture data.
		Must be carefull that SDA, SCL signals on demo board are 3.3V pulled up resistor. 
		In this example, we connect SDA, SCL signals to SDA, SCL of the other MCB1700
		(or IAR LPC1768) board running Master_Slave_Interrupt example.
				
	Serial display configuration:(e.g: TeraTerm, Hyperterminal, Flash Magic...) 
		 115200bps 
		 8 data bit 
		 No parity 
		 1 stop bit 
		 No flow control 
	
	Running mode:
		This example can run on RAM/ROM mode.
							
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Define the maximum monitor buffer size 'BUFFER_SIZE'
		- Step 2: Build example.
		- Step 3: Burn hex file into board (if run on ROM mode)
				  Burn hex file of Master_Slave_Interrupt example into the other board.
		- Step 4: Connect UART0 on this board to COM port on your computer
		- Step 5: Configure hardware and serial display as above instruction 
		- Step 6: Run example
				  Input a buffer size (smaller than BUFFER_SIZE)
				  Press RESET button on the board running Master_Slave_Interrupt example
				  Look at the PC's terminal screen to see the captured data.
		
		(Pls see "LPC17xx Example Description" document - chapter "Examples > I2C > Monitor"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil
