 ******************** (C) COPYRIGHT 2010 NXPSemiconductors *******************
 * @file    GPIO\GPIO_Interrupt\abstract.txt 
 * @author  NXP MCU SW Application Team
 * @version 2.0
 * @date    
 * @brief   Description of the GPIO Interrupt example.
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ******************************************************************************
  
@Example description:
	Purpose:
		This example describes how to use GPIO interrupt function.
	Process:
		Different board have different layout, so we need to have different configuration 
			- If using MCB1700 board: Interrupt is configured to use P0.25 pin (ACD potentiometter)
			- If using IAR-LPC1768-KS board: External interrupt is configured to use P0.23 pin (BUT1 button) 
		
		Turn the ADC potentiometer according to clock direction until interrupt happen (If using MCB1700 board).
		Hit the BUT1 button (If using IAR-LPC1768-KS board)to make interrupt happen.

@Directory contents:
	\EWARM: includes EWARM (IAR) project and configuration files
	\Keil:	includes RVMDK (Keil)project and configuration files 
	
	lpc17xx_libcfg.h: Library configuration file - include needed driver library for this example 
	makefile: Example's makefile
	gpio_int.c: Main program

@How to run:
	Hardware configuration:		
		This example was tested on:
			Keil MCB1700 with LPC1768 vers.1
				These jumpers must be configured as following:
				- VDDREGS: ON 
				- VBUS: ON
				- LED: ON
				- INT0: ON
				- Remain jumpers: OFF
			IAR LPC1768 KickStart vers.A
				These jumpers must be configured as following:
				- PWR_SEL: depend on power source
				- DBG_EN : ON
				- ACC_IRQ/LED2: 2-3 (LED2)
				- Remain jumpers: OFF
				
	
	Running mode:
		This example can run on RAM/ROM mode.
					
		Note: If want to burn hex file to board by using Flash Magic, these jumpers need
		to be connected:
			- MCB1700 with LPC1768 ver.1:
				+ RST: ON
				+ ISP: ON
			- IAR LPC1768 KickStart vers.A:
				+ RST_E: ON
				+ ISP_E: ON
		
		(Please reference "LPC1000 Software Development Toolchain" - chapter 4 "Creating and working with
		LPC1000CMSIS project" for more information)
	
	Step to run:
		- Step 1: Choose correct working board: In gpio_int.c file
			+ If using MCB1700 board, setting:
				#define MCB_LPC_1768	
				//#define IAR_LPC_1768	
			+ If using IAR-LPC1768-KS board, setting:
				//#define MCB_LPC_1768	
				#define IAR_LPC_1768	
			(Should not enable/disable both symbols at the same time)
		- Step 2: Build example.
		- Step 3: Burn hex file into board (if run in ROM mode)
		- Step 4: Reset the board
		- Step 5: if using MCB1700: Turn ACD potentiometter until interrupt occurs, then we see LED P1.29 blinking 8 times.
				  if using IAR-LPC1768-KS board:  Press BUT1 button then LED2 will be blinking 8 times
				  
		(Pls see "LPC17xx Example Description" document - chapter "Examples > GPIO > GPIO_Interrupt"
		for more details)
		
@Tip:
	- Open \EWARM\*.eww project file to run example on IAR
	- Open \RVMDK\*.uvproj project file to run example on Keil
