/* #############################################################################
**    Archivo        : main.c
**    Proyecto       : STM32F103C8_Matrizgauss
**    Procesador     : STM32F103C8T6
**    Plataforma     : Blue Pill
**    Herramienta    : Mbed Compiler
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 17-02-2020, 22:53, # CodeGen: 0
**    Descripción    :
**         Este programa resuelve un sistema de ecuaciones de 3x3 por el metodo de Gauss
**         This module contains user's application code.
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          -  Francisco Sarabia López, Antulio Morgado Valle(plantilla)
**
**   Versión        : Alpha
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
//#include "LedRGB.h"
#include "stdio.h"

/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define  on             0           // Estado para boton presionado
#define off             1           // Estado para boton sin presionar
#define hold            2           // Estado para boton mantenido
#define release         3           // Estado para boton liberado
#define FALSE           0           // Estado FALSO
#define TRUE            1           // Estado VERDADERO
#define Ticker_Rate     1000        // Periodo de interrupción Ticker (us)
#define Baud_Rate       115200      // Velocidad de Transmisión de la Terminal
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
Ticker      TimerInt;               // Inicializa la Interrupción por Timer
DigitalOut  led_monitor(LED1);      // Inicializa el LED Monitor
DigitalOut  led_testigo(PB_1);      // Inicializa el LED Testigo
PwmOut      led_pwm(PA_7);          // Inicializa el LED PWM
AnalogIn    sensor1(PB_0);          // Inicializa Canal Analógico para sensor 1
Serial      terminal(PA_2, PA_3);   // Inicializa la Comunicación Serial a la PC
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint16_t Rate=Ticker_Rate/2;        // Velocidad de barrido (500us = 0.5ms)
uint16_t counter=250;               // Cuenta inicial de 250us
/* END variables */

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
        // Las Definiciones de Funciones Prototipo 
        // y Apuntadores a Vectores de Interrupciones van aquí !
void TimerInt_OnInterrupt(void);  
void Blinking_Led(void);
void ImprimirMatriz(float Matriz[3][4]);
void IntercambiaFilas(float Matriz[][4], int F, int C);
void EliminacionDiag(float Matriz[][4], int C);

/* END prototypes */

/* END definitions */  
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                           // Inicialización de variables, puertos e interrupciones
confSysClock();             // Inicialización del Sistema, Configure system clock (72MHz HSE clock, 48MHz USB clock)
TimerInt.attach_us(&TimerInt_OnInterrupt, Ticker_Rate);   // Le asigna el periodo de interrupción de 1ms (Ticker_Rate=1000)

terminal.baud(Baud_Rate);      // Se configura la velocidad de transmisión e inicia la comunicación serial.    
terminal.printf(" System is Wake Up!.\n\r"); 

    while (true)                // El Lazo del Programa principal está aquí !!!
    {
        Blinking_Led();             // Parapadeo del LED por Software
        led_pwm = sensor1.read();   // El Led se encenderá de acuerdo al valor del sensor
        terminal.printf("INSTITUTO POLITECNICO NACIONAL \r\n");
        terminal.printf("\n EEEEEEE       SSSS      IIIIIII     M      M    EEEEEEE \r\n");
        terminal.printf(  " E            S             I        M M  M M    E \r\n");
        terminal.printf(  " EEEEEEE       SSSS         I        M  MM  M    EEEEEEE \r\n");
        terminal.printf(  " E                 S        I        M      M    E \r\n"); 
        terminal.printf(  " EEEEEEE       SSSS      IIIIIII     M      M    EEEEEEE \r\n");
        terminal.printf(  "\n Francisco Sarabia Lopez\r\n"); 
        terminal.printf(  "\n Ingenieria en Comunicaciones y Electronica\r\n");
        
//----------------------------------------------------------------------------------------------
// Funciones aparte
//----------------------------------------------------------------------------------------------

//Funcion imprimir

//----------------------------------------------------------------------------------------------
// Main de matriz por metodo de gauss
//----------------------------------------------------------------------------------------------
        float matriz[3][4];//matriz con los datos igualados de las ecuaciones incluidas
        float X,Y,Z;
        float FAux1[4];//Filas auxiliares
        float FAux2[4];
        int i,j,k,f,c;
        //Valores de prueba
        matriz[0][0]=0;
        matriz[0][1]=2;
        matriz[0][2]=0.5;
        matriz[0][3]=7; //Igualdad primera ecuacion
        matriz[1][0]=5;
        matriz[1][1]=0.33;
        matriz[1][2]=1;
        matriz[1][3]=0; //Igualdad segunda ecuacion
        matriz[2][0]=3;
        matriz[2][1]=4;
        matriz[2][2]=2;
        matriz[2][3]=1; //Igualdad tercera ecuacion

        ImprimirMatriz(matriz);

        for (i=0;i<3;i++)
        {
            //Compriobacion de diagonales diferentes a cero
            if(matriz[i][i]==0)
            {
                f=i;
                c=i;
                IntercambiaFilas(matriz,f,c);
                ImprimirMatriz(matriz);
            }
            //Eliminacion de numeros
            EliminacionDiag(matriz,i);
            ImprimirMatriz(matriz);
        }
        //Formulas para las incógnitas
        Z=matriz[2][3]/matriz[2][2];
        Y=(matriz[1][3]-(Z*matriz[1][2]))/matriz[1][1];
        X=(matriz[0][3]-(Z*matriz[0][2])-(Y*matriz[0][1]))/matriz[0][0];

        terminal.printf("\n\n X= %.2f  \t Y= %.2f \t Z= %.2f ", X, Y, Z);
        return 0; 
        
//----------------------------------------------------------------------------------------------
// Finaliza Main de Gauss
//----------------------------------------------------------------------------------------------
           
    }
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
                // Las Rutinas de Atención a Interrupciones van aquí !
void TimerInt_OnInterrupt()          // Rutina de Atención al Ticker
{
    
}
/* END Events */   
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Blinking_Led()     // Software Blinking routine for LED 
{
        // The on-board LED is connected, via a resistor, to +3.3V (not to GND). 
        // So to turn the LED on or off we have to set it to 0 or 1 respectively
    led_testigo = 1;        // turn the LED on (using Positive Logic)
    wait_ms(200);           // 200 millisecond
    led_testigo = 0;        // turn the LED off (using Positive Logic)
    wait_ms(1000);          // 1000 millisecond
}

void ImprimirMatriz(float Matriz[3][4])
    {
    int i,j;
    for(i=0;i<3;i++)
    {
        for(j=0;j<3;j++)
        {
            printf(" %7.2f", Matriz[i][j]);
            if(j==0)
            {
                printf("x");
            }
            else if(j==1)
            {
                printf("y");
            }
            else if(j==2)
            {
                printf("z");
            }
        }
        printf("\t = %7.2f \n", Matriz[i][j]);
    }
    printf("\n\n");
}

void IntercambiaFilas(float Matriz[][4], int F, int C) //Intercambio de filas si el valor (F,C)=0;
{
    int i,j,k;
    float FAux1[4]; 
    float FAux2[4];
    
    if (Matriz[F][C]==0)            
    {
        j=0;
        for(k=0;k<3;k++)
        {
            if (Matriz[k][C]!=0)
            {
                j=k;
            }
            if(j!=0)
            {
                k=3;
            }
        }
    /*if (k==3 && j==0)
    {
        printf("\n\n Nmms esta no es una matriz 3x3, resuelvela solo >:c \n\n");
    }*/

    printf("\t Se intercambia la fila %d por la fila %d \n\n", F+1, j+1);
        for(i=0;i<4;i++)
        {
            FAux1[i]=Matriz[F][i];
            FAux2[i]=Matriz[j][i];
        }
        for(i=0;i<4;i++)
        {
            Matriz[F][i]=FAux2[i];
            Matriz[j][i]=FAux1[i];
        }
    }
}

void EliminacionDiag(float Matriz[][4], int C)
{
    float coef,coef1;
    float FAux1[4]; 
    float FAux2[4];
    int i,j,k;
    coef=Matriz[C][C];
    
    for (i=0;i<3;i++)
    {
        
        if(i!=C)
        {
            if(Matriz[i][C]!=0)
            {
                coef1=Matriz[i][C];
            
                for (j=0; j<4; j++)
                {
                    FAux1[j]=coef1*Matriz[C][j];
                    FAux2[j]=coef*Matriz[i][j];
                }
                
                for (k=0;k<4;k++)
                {
                    FAux2[k]=FAux1[k]-FAux2[k];
                }
            
                for (k=0;k<4;k++)
                {
                    Matriz[i][k]=FAux2[k];
                }
            }
            else
            {
                printf("\n\n\t dato (%d,%d) es cero \n\n",i,C);
            }   
        }
    }
}
/* END functions */    
                
/* END program */

/*+-----------------------------------------------------------------------------       
*+ La documentación va aquí!:
*+-----------------------------------------------------------------------------       
*+
*+
*+----------------------------------------------------------------------------*
*+
*+   Powered by
*+
*+          T H E     A N T U L I U ' S   T E A M   R&D  Unltd 
*+
*+  Research, Development, Systems, Equipment, Support & Spare Parts.
*+  (C) Copyright 1989-2019, All Rights Reserved            
*+
*+  Welcome to The Beaners Proyect Community!                   
*+----------------------------------------------------------------------------*/

/* END documentation */ 

/* END Mbed */ 