/* #############################################################################
**    Archivo        : main.c
**    Proyecto       : STM32F103C8_Caratula
**    Procesador     : STM32F103C8T6
**    Plataforma     : Blue Pill
**    Herramienta    : Mbed Compiler
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 17-02-2020, 22:53, # CodeGen: 0
**    Descripción    :
**         Este proyecto hace una carátula para mostrar la presentación
**         This module contains user's application code.
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          -  Francisco Sarabia López, Antulio Morgado Valle(plantilla)
**
**   Versión        : Alpha
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
//#include "LedRGB.h"
//#include "stdio.h"

/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define  on             0           // Estado para boton presionado
#define off             1           // Estado para boton sin presionar
#define hold            2           // Estado para boton mantenido
#define release         3           // Estado para boton liberado
#define FALSE           0           // Estado FALSO
#define TRUE            1           // Estado VERDADERO
#define Ticker_Rate     1000        // Periodo de interrupción Ticker (us)
#define Baud_Rate       115200      // Velocidad de Transmisión de la Terminal
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
Ticker      TimerInt;               // Inicializa la Interrupción por Timer
DigitalOut  led_monitor(LED1);      // Inicializa el LED Monitor
DigitalOut  led_testigo(PB_1);      // Inicializa el LED Testigo
PwmOut      led_pwm(PA_7);          // Inicializa el LED PWM
AnalogIn    sensor1(PB_0);          // Inicializa Canal Analógico para sensor 1
Serial      terminal(PA_2, PA_3);   // Inicializa la Comunicación Serial a la PC
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint16_t Rate=Ticker_Rate/2;        // Velocidad de barrido (500us = 0.5ms)
uint16_t counter=250;               // Cuenta inicial de 250us
/* END variables */

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
        // Las Definiciones de Funciones Prototipo 
        // y Apuntadores a Vectores de Interrupciones van aquí !
void TimerInt_OnInterrupt(void);  
void Blinking_Led(void);
double funcion(float x);

/* END prototypes */

/* END definitions */  
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                           // Inicialización de variables, puertos e interrupciones
confSysClock();             // Inicialización del Sistema, Configure system clock (72MHz HSE clock, 48MHz USB clock)
TimerInt.attach_us(&TimerInt_OnInterrupt, Ticker_Rate);   // Le asigna el periodo de interrupción de 1ms (Ticker_Rate=1000)

terminal.baud(Baud_Rate);      // Se configura la velocidad de transmisión e inicia la comunicación serial.    
terminal.printf(" System is Wake Up!.\n\r"); 

    while (true)                // El Lazo del Programa principal está aquí !!!
    {
        Blinking_Led();             // Parapadeo del LED por Software
        led_pwm = sensor1.read();   // El Led se encenderá de acuerdo al valor del sensor
        terminal.printf("INSTITUTO POLITECNICO NACIONAL \r\n");
        terminal.printf("\n EEEEEEE       SSSS      IIIIIII     M      M    EEEEEEE \r\n");
        terminal.printf(  " E            S             I        M M  M M    E \r\n");
        terminal.printf(  " EEEEEEE       SSSS         I        M  MM  M    EEEEEEE \r\n");
        terminal.printf(  " E                 S        I        M      M    E \r\n"); 
        terminal.printf(  " EEEEEEE       SSSS      IIIIIII     M      M    EEEEEEE \r\n");
        terminal.printf(  "\n Francisco Sarabia Lopez\r\n"); 
        terminal.printf(  "\n Ingenieria en Comunicaciones y Electronica\r\n"); 


    int n;
    float i, a, b;
    double fa, fx, fb, dx, area;

    printf("Ingresa el valor del limite inferior\n");
    scanf("%f", &a);
    printf("Ingresa el valor del limite superior\n");
    scanf("%f", &b);
    printf("Ingresa el numero de particiones\n");
    scanf("%d", &n);

    fx = 0.0;
    fa = funcion(a);
    fb = funcion(b);
    dx = (b - a)/(float)n;
    for (i = a; i < b; i += dx)
    {
        fx = fx + funcion(i);
    }
    area = (fx + (fa + fb) / 2) * dx;
    printf("%0.10f\n", area);
    return 0;
                           
    }
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
                // Las Rutinas de Atención a Interrupciones van aquí !
void TimerInt_OnInterrupt()          // Rutina de Atención al Ticker
{
    
}
/* END Events */   
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Blinking_Led()     // Software Blinking routine for LED 
{
        // The on-board LED is connected, via a resistor, to +3.3V (not to GND). 
        // So to turn the LED on or off we have to set it to 0 or 1 respectively
    led_testigo = 1;        // turn the LED on (using Positive Logic)
    wait_ms(200);           // 200 millisecond
    led_testigo = 0;        // turn the LED off (using Positive Logic)
    wait_ms(1000);          // 1000 millisecond
}

// Definicion de la funcion matematica a evaluar
double funcion(float x)
{
    double r;
    r=exp(x*x);//funcion e^(x^2)
    return r;
}
/* END functions */    
                
/* END program */

/*+-----------------------------------------------------------------------------       
*+ La documentación va aquí!:
*+-----------------------------------------------------------------------------       
*+
*+
*+----------------------------------------------------------------------------*
*+
*+   Powered by
*+
*+          T H E     A N T U L I U ' S   T E A M   R&D  Unltd 
*+
*+  Research, Development, Systems, Equipment, Support & Spare Parts.
*+  (C) Copyright 1989-2019, All Rights Reserved            
*+
*+  Welcome to The Beaners Proyect Community!                   
*+----------------------------------------------------------------------------*/

/* END documentation */ 

/* END Mbed */ 