#include "mbed.h"
//#include "FastPWM.h"
#include "HIDScope.h"
//#include "tsi_sensor.h"

#define V1_CLOSE  D2
#define V1_OPEN   D3
#define V2_CLOSE  D4
#define V2_OPEN   D5
#define V3_CLOSE  A2
#define V3_OPEN   A3
#define V4_CLOSE  D8
#define V4_OPEN   D9

#define TSI_A PTB16
#define TSI_B PTB17

#define PRESSURE PTB0
#define EXTERNAL_SETPOINT PTC2

DigitalOut v1open(V1_OPEN);
DigitalOut v1close(V1_CLOSE);
HIDScope scope(3);
AnalogIn ain_setpoint(EXTERNAL_SETPOINT);
AnalogIn pressure(PRESSURE);
//TSIAnalogSlider slider(TSI_A, TSI_B, 100);
Ticker valvetick;

volatile float setpoint1;

static inline float getPressure_Pa(void)
{
    float voltage = pressure.read()*3.3;
    float sensor_output = (voltage*2)-0.2;//offset compensation
    float press = sensor_output*10000; //gain (might be off a bit. Is the full scale range without the offset? then it would be ~9000).
    return press;
}

void valvecontrol(void)
{
    static uint16_t usbcounter = 0;
    float meas = getPressure_Pa();
    setpoint1= ain_setpoint.read()*60000;
    if(setpoint1 - meas >2500) {
        v1close = 0;
        v1open = 1;
    } else if (meas - setpoint1 > 2500) {
        v1close = 1;
        v1open = 0;
    } else
        v1open = v1close = 0;
    usbcounter++;
    if(usbcounter == 20) {
        scope.set(0,setpoint1);
        scope.set(1,meas);
        scope.set(2,meas);
        scope.send();
        usbcounter = 0;
    }
}

int main()
{
    valvetick.attach(valvecontrol,0.001);
    while(1) {
        //setpoint1 = ain_setpoint.read()*30000;
        //scope.set(2,ain_setpoint);
        wait(0.1);
    }
}
