Watchdog wd;

#if defined(speedMaster)
    InterruptIn tractorSpeedRead(PB_1);     // define interrupt pin for tractor speed calculation MASTER MODE
    DigitalOut quinconceOut(PA_0,PullUp);                                  // sincro per quinconcio out
    DigitalIn quinconceIn(PA_1,PullUp);
    //DigitalOut ProvaSincro(D8,PullUp);
    InterruptIn DcEncoder(PA_14);
#else
    InterruptIn tractorSpeedRead(PA_5);     // define interrupt pin for tractor speed calculation SLAVE MODE
    //DigitalIn quinconceIn(PA_0,PullUp);
    InterruptIn quinconceIn(PA_0);
    DigitalIn quinconceOut(PA_1,PullUp);                                  // sincro per quinconcio out
    InterruptIn DcEncoder(PA_14);
#endif

DigitalIn TBzeroPinInputRev(PB_11);             // define input of reading zero position of distributor wheel
//DigitalIn ElementPosition(PB_2);                // define input for reading if seed element is down or up for master module, speed clock for slave
InterruptIn ElementPosition(PB_2);                // define input for reading speed of seed wheel with fixed 25 hole
DigitalIn seedWheelZeroPinInputRev(PB_12);      // define input of reading zero position of seeding wheel
DigitalIn buttonUser(PC_13);                    // pulsante su scheda

DigitalOut speedClock(PA_6);                    // define out for speed clock repeater

InterruptIn pwmCheck(PB_13);
PwmOut SDmotorPWM(PB_13);                       // define frequency command for seeding whell motor driver
DigitalOut SDmotorInB(PB_14);                   // sd motor half bridge direction selector
DigitalOut SDmotorInA(PB_15);                   // SD motor half bridge direction selector
DigitalIn enDiag_A(PB_5);                       // SD motor fault condition input A
DigitalIn enDiag_B(PB_4);                       // SD motor fault condition input A
AnalogIn SDcurrent(PA_4);                       // SD power current feedback

DigitalOut TBmotor_M1(PC_8);                    // TB motor step division M1
DigitalOut TBmotor_M2(PC_6);                    // TB motor step division M2
DigitalOut TBmotor_M3(PC_6);                    // TB motor step division M3
DigitalOut TBmotorRst(PC_4);                    // TB motor driver reset
DigitalOut TBmotorStepOut(PB_3);                // TB motor step command
DigitalOut TBmotorDirecti(PA_10);               // TB motor direction command


#if defined(speedMaster)
    DigitalOut led(LED1);                           // ATTENZIONE: LED1 E' SU PA5 / D13
#else
    DigitalOut led(PC_7);                           // ATTENZIONE: LED1 E' SU PA5 / D13
#endif

DigitalIn zeroRequestIn(PB_6);          // define input of zero request for slave module
DigitalIn runRequestIn(PB_9);           // define input of run request for slave module

#if defined(canbusActive)
    CAN can1(PA_11,PA_12,100000);           // CAN BUS channel for communication with other slave and master consolle
    int checkState=0;
#endif
CANMessage txMsg;
CANMessage rxMsg;

#if defined(pcSerial)
    Serial pc(USBTX, USBRX,250000);         // serial channel for PC communication
#else
    #if defined(speedTime)
        Serial pc(USBTX, USBRX,250000);         // serial channel for PC communication
    #endif
#endif

