#include "mbed.h"
#define MAX_ELEMENTS 5

Mutex mutex1;
Mutex mutex2;
ConditionVariable full(mutex1);
ConditionVariable empty(mutex2);
Thread producer;
Thread consumer;


typedef struct element_s{
    uint8_t counter;
} element_t;


MemoryPool<element_t, MAX_ELEMENTS> mpool;
Queue<element_t, MAX_ELEMENTS> queue;
volatile int current_elements = 0;



void producer_thread(void) {
    while (1) {
      mutex1.lock();
      if (current_elements == MAX_ELEMENTS) {
        printf("The queue is full!\n");
        full.wait();    
      }
      element_t *element = mpool.alloc();
      element->counter = current_elements+1; 
      queue.put(element);
      current_elements++;
      printf("Adding element, now the queue is %d\n", current_elements);
      if (current_elements == 1) {
        full.notify_all();
      }
      mutex1.unlock();
      // randomly decide to keep producing or start consuming
      if (rand() % 10 < 2) {
            wait(rand()%2);
    }
    }
}

void consumer_thread(void) {
    while (1) {
        mutex1.lock();
        if (current_elements == 0) {
          printf("The queue is empty!\n");
          full.wait();    
        }
        osEvent evt = queue.get();
        if (evt.status == osEventMessage) {
          element_t *element = (element_t*)evt.value.p;
          mpool.free(element);
          current_elements--;
        }
        
        printf("Removing element, now the queue is %d\n", current_elements);
        if (current_elements == MAX_ELEMENTS-1) {
          full.notify_all();   
        }    
        mutex1.unlock();
        
        // randomly decide to keep consuming or start producing
        if (rand() % 10 < 2) {
            wait(rand()%2);
        }
    }
}

int main() {
    producer.start(producer_thread);
    consumer.start(consumer_thread);
}
