/*
 *  Copyright (c) 2012 Neal Horman - http://www.wanlink.com
 *  
 *  License: MIT open source (http://opensource.org/licenses/MIT)
 *      Summary;
 *      Use / modify / distribute / publish it how you want and 
 *      if you use it, or don't, you can't hold me liable for how
 *      it does or doesn't work.
 *      If it doesn't work how you want, don't use it, or change
 *      it so that it does work.
 *
 *      Modified for use with FRDM-K64F and FRDM-KL25Z by Francesco Adamo
 */
 
#include "mbed.h"
#include "Adafruit_SSD1306.h"


#ifdef TARGET_K64F
 #define SPI_CLK     PTD1
 #define SPI_MOSI    PTD2
 #define SPI_MISO    PTD3
 #define SPI_CS      PTD0
 #define DC          PTC4
 #define RST         PTC3

  #define I2C_SDA     PTE25
  #define I2C_SCL     PTE24
#elif defined(TARGET_KL25Z)
 #define SPI_CLK     PTD1
 #define SPI_MOSI    PTD2
 #define SPI_MISO    PTD3
 #define SPI_CS      PTD0
 #define DC          PTD5
 #define RST         PTA13

 #define I2C_SDA     PTE0
 #define I2C_SCL     PTE1
#endif
 
DigitalOut myled(LED_GREEN);
Adafruit_SSD1306_SPI display(SPI_MOSI, SPI_CLK, SPI_CS, DC, RST, 64, 128);

int main() {   
    int k = 0;

    display.splash();
    wait(2.0);
    display.clearDisplay();
    
    display.printf("%ux%u OLED Display\r\n", display.width(), display.height());    
    while(1)
    {
        myled = !myled;
        display.printf("%u\r", k++);
        display.display();
        wait(0.1);
    }
}