/* 
    MS5803_14BA with 0.96" OLED Display
 */
 
#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "MS5803_14BA.h"

//#define DISPLAY_USES_SPI
//#define DISPLAY_USES_I2C

#ifdef TARGET_K64F
 #define SPI_SCK     PTD1
 #define SPI_MOSI    PTD2
 #define SPI_MISO    PTD3
 #define SPI_CS      PTD0
 #define I2C_SDA     PTE25
 #define I2C_SCL     PTE24
 #define displayDC   PTC4
 #define displayRST  PTC3
#elif defined(TARGET_KL25Z)
 #define SPI_SCK     PTD1
 #define SPI_MOSI    PTD2
 #define SPI_MISO    PTD3
 #define SPI_CS      PTD0
 #define I2C_SDA     PTE0
 #define I2C_SCL     PTE1
 #define displayDC   PTD5
 #define displayRST  PTA13
#endif

#define descentSL   (double) 23.0    // Descent speed limit in m/s
#define liftSL      (double) 9.0     // Lift speed limit in m/s

#define LED_ON 0
#define LED_OFF 1

#ifdef DISPLAY_USES_SPI
 // an SPI sub-class that provides a constructed default
 class SPIPreInit : public SPI
 {
 public:
     SPIPreInit(PinName mosi, PinName miso, PinName clk) : SPI(mosi,miso,clk)
     {
        format(8, 3);
        frequency(100000);
     };
 };

 SPIPreInit gSpi(SPI_MOSI, NC, SPI_SCK);
 Adafruit_SSD1306_Spi display(gSpi, displayDC, displayRST, SPI_CS, 64, 128);
#elif defined(DISPLAY_USES_I2C)
 #define DISPLAY_I2C_ADDRESS    0x00
 
 // an I2C sub-class that provides a constructed default
 class I2CPreInit : public I2C
 {
 public:
     I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
     {
         frequency(400000);
         start();
     };
 };

 I2CPreInit gI2C(I2C_SDA, I2C_SCL);
 Adafruit_SSD1306_I2c display(gI2C, displayRST, DISPLAY_I2C_ADDRESS, 64, 128);
#endif
 
Ticker ticker;
char tmpstr[50];
Serial pc(USBTX, USBRX);
MS5803_14BA  sensor(I2C_SDA, I2C_SCL, 0x3B, D1_OSR_4096, D2_OSR_4096); // SDA, SCL, I2C_address (0x76 or 0x77 look at MS5803.h)
bool volatile tick = false;
uint8_t k;
double p, p0 = 0.0, pp = 0.0, h = 0.0, hmax = 0.0, t = 20.0;
DigitalOut greenLED(LED_GREEN);
DigitalOut redLED(LED_RED);
//DigitalOut blueLED(LED_BLUE); // blueLED is not usable because it is shared with the SPI0_SCK line!

void ticker_ISR() {
    tick = true;
}

void setup() {
    greenLED = LED_OFF;
    redLED = LED_OFF;
    pc.baud(115200);
    sprintf(tmpstr, "MS5803 demo\n");
    pc.printf(tmpstr);
    
    sensor.reset();

#if defined(DISPLAY_USES_SPI) || defined(DISPLAY_USES_I2C)
    display.printf(tmpstr);
#endif
    
    sprintf(tmpstr, "Calibrating...\r\n\r\n");

 #if defined(DISPLAY_USES_SPI) || defined(DISPLAY_USES_I2C)
    display.printf(tmpstr);
    display.display();
#endif

    // gets the reference (surface) pressure as the mean of 10 initial measures
    for (k = 1; k <= 10; k++) {
        sensor.convert();
                p0 = (p0*(k-1) + sensor.pressure)/k;
    }
    hmax = 0.0;
        
 #if defined(DISPLAY_USES_SPI) || defined(DISPLAY_USES_I2C)
    display.clearDisplay();
 //   display.setTextSize((uint8_t) 2);
 #endif
    ticker.attach(&ticker_ISR, 0.1);    
}

int main()
{   
    setup();
        
    while(1) {
            while(!tick); // wait a timer interrupt
      tick = false;
            greenLED = LED_ON;

            sensor.convert();
            p = sensor.pressure; // pressure in mBar
            t = sensor.temperature; // temperature in degC
            h = (p - p0)/100; // depth in m
            hmax = (h > hmax) ? h : hmax; // max depth
/*        
            if ((p - pp)/60 > descentSL)
        redLED = LED_ON;
            else
                redLED = LED_OFF;
        
            if ((p - pp)/60 < -liftSL)
                redLED = LED_ON;
            else
                redLED = LED_OFF;

            pp = p;
*/
            sprintf(tmpstr, "%.1f mBar/%.1f m\r\n%.1f C", p, h, t);
            pc.printf(tmpstr);//"%.3f\n", p);
            pc.printf("\n");
                    
#if defined(DISPLAY_USES_SPI) || defined(DISPLAY_USES_I2C)
      display.clearDisplay();
      display.setTextCursor(0, 0);
      display.printf("%s", tmpstr);
      display.display();
#endif
      greenLED = LED_OFF;
    }
}
