/*
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.

  * Demo Program
  * Barometer Sensor (Altimeter) MS5803-01BA of MEAS Switzerland     (www.meas-spec.com).
  * The driver uses I2C mode (sensor PS pin low).
  * Other types of MEAS are compatible but not tested.
  * Written by Raig Kaufer distribute freely!
  *
  * Modified for MS5803-14BA by Francesco Adamo, Italy
 */

#include "mbed.h"
#include "MS5803_14BA.h"


#ifdef TARGET_K64F
 #define SPI_SCK     PTD1
 #define SPI_MOSI    PTD2
 #define SPI_MISO    PTD3
 #define SPI_CS      PTD0
 #define I2C_SDA     PTE25
 #define I2C_SCL     PTE24
#elif defined(TARGET_KL25Z)
 #define SPI_SCK     PTD1
 #define SPI_MOSI    PTD2
 #define SPI_MISO    PTD3
 #define SPI_CS      PTD0
 #define I2C_SDA     PTE0
 #define I2C_SCL     PTE1
#endif

Serial pc(USBTX, USBRX);
MS5803_14BA  ps(I2C_SDA, I2C_SCL, MS5803_ADDRC_H, D1_OSR_4096, D2_OSR_4096); // SDA, SCL, I2C_address (0x76 or 0x77 look at MS5803.h)

int main() {
    pc.baud(115200);
    pc.printf("MS5803 demo\r\n");
    
    while (1) {
        ps.convert();
        pc.printf("%4.1f, %4.1f\r\n", ps.getPressure(), ps.getTemperature());
        wait(0.5);
    }
}
