#include "mbed.h"
#include "ADS7828.h"

DigitalOut myled(LED_GREEN);
Serial pc(USBTX, USBRX);
ADS7828  ADC(I2C_SDA, I2C_SCL, 100000, 0x00);

int main() {
    int data;
    
    pc.baud(115200);
    pc.printf("Hello, World!\r\n");
    
    while(1) {
        myled != myled;
        
        data = ADC.readRawValue(MODE_SE | MODE_INTERNAL_REF_ON_ADC_ON, CH0_SE);
        if (data == -1)
            pc.printf("Error reading data from ADC!\r\n");
        else
            pc.printf("Conversion result: 0x%04x = %.3f V\r\n", data, 2.5F/4096*data);
            
        wait(0.2);
    }
}
