/***************************************************************************
 * @author Francesco Adamo
 *
 * @section LICENSE
 *
 * Copyright (c) 2014 Francesco Adamo
 *
 * @section DESCRIPTION
 *
 *  ADS7828.H
 *  Header file for library ADS7828     
 *  The ADS7828 is a 12-bits, 8-channels, I2C-interfaced from Texas Instruments
 *  
 *  (c) 2014 - By Francesco Adamo, Italy
*****************************************************************************/

#ifndef ADS7828_H
#define ADS7828_H

#include "mbed.h"

#define ADS7828_BASE_ADDRESS    0x90

// ADS7828 command codes
#define CH01_DIFF   (uint8_t) (0x00 << 4) // CH0+, CH1-
#define CH23_DIFF   (uint8_t) (0x01 << 4) // CH2+, CH2-
#define CH45_DIFF   (uint8_t) (0x02 << 4) // CH4+, CH5-
#define CH67_DIFF   (uint8_t) (0x03 << 4) // CH6+, CH7-
#define CH10_DIFF   (uint8_t) (0x04 << 4) // CH1+, CH0-
#define CH32_DIFF   (uint8_t) (0x05 << 4) // CH3+, CH2-
#define CH54_DIFF   (uint8_t) (0x06 << 4) // CH5+, CH4-
#define CH76_DIFF   (uint8_t) (0x07 << 4) // CH6+, CH6-

#define CH0_SE      (uint8_t) (0x00 << 4)
#define CH2_SE      (uint8_t) (0x01 << 4)
#define CH4_SE      (uint8_t) (0x02 << 4)
#define CH6_SE      (uint8_t) (0x03 << 4)
#define CH1_SE      (uint8_t) (0x04 << 4)
#define CH3_SE      (uint8_t) (0x05 << 4)
#define CH5_SE      (uint8_t) (0x06 << 4)
#define CH7_SE      (uint8_t) (0x07 << 4)

#define MODE_SE     (uint8_t) (0x01 << 8)
#define MODE_DIFF   (uint8_t) 0x00

#define MODE_POWER_DOWN_BETWEEN_CONVERSIONS  (uint8_t) (0x00 << 2)
#define MODE_INTERNAL_REF_OFF_ADC_ON (uint8_t) (0x01 << 2)
#define MODE_INTERNAL_REF_ON_ADC_OFF (uint8_t) (0x02 << 2)
#define MODE_INTERNAL_REF_ON_ADC_ON (uint8_t) (0x03 << 2)


class ADS7828 {
    private:
        I2C _i2c;
        char address;
        double VFSR;

    public:
        ADS7828(PinName sda, PinName scl); // Constructor
        ADS7828(PinName sda, PinName scl, int freq); // Constructor overload
        ADS7828(PinName sda, PinName scl, int freq, char subAddress); // Constructor overload
        ADS7828(PinName sda, PinName scl, int freq, char subAddress, double VREF); // Constructor overload
        
        int readRawValue(char mode, char channel);
        double readAnalogValue(char mode, char channel);
};

#endif //#ifndef ADS7828_H
