#include "mbed.h"
#include "AD7730.h"

#ifdef TARGET_K64F
 #define SPI_SCK     PTD1
 #define SPI_MOSI    PTD2
 #define SPI_MISO    PTD3
 #define SPI_CS      PTD0
 #define READY       PTC4
 #define I2C_SDA     PTE25
 #define I2C_SCL     PTE24
#elif defined(TARGET_KL25Z)
 #define SPI_SCK     PTD1
 #define SPI_MOSI    PTD2
 #define SPI_MISO    PTD3
 #define SPI_CS      PTD0
 #define READY       PTD5
 #define I2C_SDA     PTE0
 #define I2C_SCL     PTE1
#endif

DigitalOut greenLED(LED_GREEN);
DigitalOut redLED(LED_RED);
DigitalOut blueLED(LED_BLUE);
Serial pc(USBTX, USBRX);
Ticker tick1;
volatile bool timerInterrupt = false;


AD7730 ad7730(SPI_MOSI, SPI_MISO, SPI_SCK, READY, SPI_CS);

void timerISR() {
    timerInterrupt = true;
    greenLED = !greenLED;    
}

int main() {
    pc.baud(115200);
    greenLED = 1;
    redLED = 1;
    blueLED = 1;    
    ad7730.initialize();
    tick1.attach(timerISR, 0.02F);

    while(1) {
        if (timerInterrupt) { 
            pc.printf("%d\r\n", ad7730.read(true));
            timerInterrupt = false;
        } 
    }    
}