#ifndef AD7730_H
#define AD7730_H

#include "mbed.h"

#define STATUS_REG  0x00
#define DATA_REG    0x01
#define MODE_REG    0x02
#define FILTER_REG  0x03
#define DAC_REG     0x04
#define OFFSET_REG  0x05
#define GAIN_REG    0x06
#define TEST_REG    0x07

class AD7730{

    public:
        AD7730(PinName mosi, PinName miso, PinName sclk, PinName ready, PinName cs);
        ~AD7730(void);
        
        int readRegistry(int registry);
        int writeRegistry(int registry, int value);
        int initialize(void);
        int systemLowCal(double wgt);
        int systemHighCal(double wgt, double fullScale);
        int read(bool _wait);
        int startConversion(bool wait); 
        void setFilter(int SF, bool chop, int filter2);
        void setFilterSF(int SF);
        void setFilterMode(int mode);
        void setFilterChop(int enabled);
        void reset(bool fullReset);
        int adjustDAC(int direction);
        void start(void);
        void stop(void);
        bool isReady(void);
        double getHz(void);

    
    private:
    
        SPI _spi;
        DigitalOut _cs;
        DigitalIn _readyDig;
        DigitalOut _LED3;
        InterruptIn *_interruptReady;
        PinName  _readyPin;
        double _fullScaleWeight;
        double _minWeight;
        double _maxWeight;
        int _readBuffer[100];
        int _bufferCount;
        int _lastValue;
        bool _continous;
        int _frequency;
        Timer _tmr;

        //define empty spi command
        static const int EMPTY_SPI = 0xFF;
        
        //internal registries
        int _mode;
        int _filter;
        int _dac;
        int _offset;
        int _gain;
        
        
        //timing variables
        Timer _exeTmr;
        int _exeTime;
        
        //error variables
        int _exeError;
        
        //private functions
        int internalZeroCal(void);
        int internalFullCal(void); 
        void interruptRead(void);
};

#endif
