#include "mbed.h"
#include "ad7606.h"

#ifdef TARGET_KL25Z
 #define MISO    PTD3
 #define SCLK    PTD1
 #define CS      PTD0
 #define CONVST  PTD5
 #define BUSY    PTA13
 #define RESET   PTC9
#elif defined(TARGET_K64F)
 #define MISO    PTD3
 #define SCLK    PTD1
 #define CS      PTD0
 #define CONVST  PTC4
 #define BUSY    PTA0
 #define RESET   PTC3
#endif


Serial pc(USBTX, USBRX);
AD7606 ad7606(MISO, SCLK, CS, CONVST, BUSY, RESET, 100000);
double aValues[8] = {0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F};
//int16_t rawValues[8] = {0, 0, 0, 0, 0, 0, 0, 0};
Ticker tick1;
DigitalOut greenLED(LED_GREEN);
volatile bool timerInterrupt = false;

void timInterrupt_ISR() {
    timerInterrupt = true;
    greenLED = !greenLED;    
}

int main() {
    greenLED = 1;
    pc.baud(115200);
    pc.printf("Hello, World!\r\n");
    ad7606.setDR(10.0f);
    tick1.attach(timInterrupt_ISR, 0.1F);
    
    while(1) {
        if (timerInterrupt) { 
            //ad7606.readRAW(rawValues);
            //pc.printf("%d, %d, %d, %d, %d, %d, %d, %d\r\n", rawValues[0], rawValues[1], rawValues[2], rawValues[3], rawValues[4], rawValues[5], rawValues[6], rawValues[7]);
            ad7606.readAnalog(aValues);
            pc.printf("%.3f, %.3f, %.3f, %.3f, %.3f, %.3f, %.3f, %.3f\r\n", aValues[0], aValues[1], aValues[2], aValues[3], aValues[4], aValues[5], aValues[6], aValues[7]);
            timerInterrupt = false;
        } 
    }    
}
