/***************************************************************************
 * @author Francesco Adamo
 *
 * @section LICENSE
 *
 * Copyright (c) 2015 Francesco Adamo
 *
 * @section DESCRIPTION
 *
 *  AD7606.H
 *  Header file for AD7606 class library
 *  The AD7606BSTZ is a 16-bits, 8-channels, SPI/Parallel-interfaced ADC from Analog Devices
 *  
*****************************************************************************/
#ifndef AD7606_H
#define AD7606_H

#include "mbed.h"

class AD7606 {
    private:
        SPI _spi;
        DigitalOut _cs;
        DigitalOut _convst;
        DigitalIn _busy;
        DigitalOut _reset;
        double _q;

    public:
        AD7606(PinName MISO, PinName SCLK, PinName CS, PinName CONVST, PinName BUSY, PinName RESET, int frequency); // Constructor
        void reset();
        void setDR(double); // Set dynamic range (10 V or 20 V), as a function of RANGE pin (0 => DR = +/- 5 V, 1 => DR = +/- 10 V)
        void readRAW(int16_t *); // Read raw values from ADC
        void readAnalog(double *); // Read analog values
};


#endif