#include "mbed.h"
#define BUTTON1 p14       // push joystick pin

InterruptIn button(BUTTON1);
DigitalOut myled(LED1);
bool _pressed = false;      // definition of the flag _pressed      

int checkFlag() {
    if( _pressed ) {
        _pressed = false;   // delete flag
        return 1;
    }
    return 0;
}

void risingISR() {            
    _pressed = true;        // set flag _pressed
}

void callISR() {            // function callISR instead an ISR          
    myled = ! myled;        // now you can use ... 
    printf("Pressed\n");    // ... printf
    wait_ms(500);           // ... wait
    myled = ! myled;        // etc.
}


int main() {
    printf("Hello Interrupt-Flag v0.1\n");
    button.rise(&risingISR);                // call ISR in OS2
    //button.rise(callback(&risingISR));    // callback in OS5
 
    while(1) {
        if(checkFlag())     // if set then call the function ISR
            callISR();
        wait_ms(10);        // only for simulator
  }
}