// 12-stufige chromatische Skala der reinen Stimmung
// https://de.wikipedia.org/wiki/Reine_Stimmung

#include "mbed.h"
#include "noten.h"

AnalogOut Aout(p18);
AnalogIn pot1(p19);

void note(float time) {
    for(float i = 0.0; i < 1.0; i+=0.01) {
        Aout = 0.2;         // Lautstärke
        wait_us(time*1000);  // Frequenz
        Aout = 0;
        wait_us(time*1000);
    }
}

int main() {
    while(1) {
        note(C);  //0.000.01
        wait(0.5);
        note(Des);
        wait(0.5);
        note(D);
        wait(0.5);
        note(Es);
        wait(0.5);
        note(E);
        wait(0.5);
        note(F);
        wait(0.5);
        note(Fis);
        wait(0.5);
        note(G);
        wait(0.5);
        note(As);
        wait(0.5);
        note(A);
        wait(0.5);
        note(B);
        wait(0.5);
        note(H);
        wait(0.5);
        note(c);
        wait(0.5);
    }
}
