/***********************************
name:   rtc.h      Version: 0.1
author: PE HTL BULME
email:  pe@bulme.at
description:
    Definition portion of the class rtc


***********************************/

#include "mbed.h"
#include "const.h"

#if !defined (RTC_H)
#define RTC_H

/** RTC Class
 */
 
 /** 
name:   rtc.h      Version: 0.1
author: PE HTL BULME
email:  pe@bulme.at
description:
    Definition portion of the class rtc


***********************************/
class RTC
{
protected:
    //PinName _sda, _scl;  
#ifdef TARGET_LPC11XX   
    I2C i2c;                    /**< I2C definition */
#endif
    char week_val;

    /**
    protected methodes for internal purposes only
    */
    void error();               /**< Error: stops and all LEDs are blinking*/

public:
    /** Create a RTC object connected to the specified pin
    * @param pin sda/scl pin to connect to
    */
    RTC();                          /**< default constructor; sda(p28), sdc(p27) */
    RTC(PinName sda, PinName scl);  /**< parameterized constructor with sda-pin, sdc-pin)*/
    ~RTC();
    char rtc_read(char address);    /**< read value from I2C bus; ToDo --> Error()*/ 
    void rtc_write(char address, char value);   /**< write value to I2C bus; ToDo --> Error()*/ 
    void rtc_init();                /**< initialize the RTC to a given date and time; ToDo --> Error()*/ 
    void rtc_alarm();
};

#endif