/***********************************
name:   rtc.cpp    Version: 0.2
author: PE HTL BULME
email:  pe@bulme.at
description:
    Implementation portion of class rtc 
    real time clock on himbed0
      
***********************************/

#include "mbed.h"
#include "const.h"
#include "rtc.h"

RTC::~RTC()
{}

#ifdef TARGET_LPC11XX
// Default constructor
RTC::RTC() : i2c(p28, p27)              // HIMBED M0
{
    i2c.frequency(40000);               // I2C Frequenz 40kHz
    char init1[2] = {0x6, 0x00};
    char init2[2] = {0x7, 0xff};
    i2c.write(0x40, init1, 2);
    i2c.write(0x40, init2, 2);

}

// Param. constructor with pins sda and scl
RTC::RTC(PinName sda, PinName scl) :  i2c(sda, scl)  //_sda(sda), _scl(scl)   // no I2C default constructor
{
    i2c.frequency(40000);               // I2C Frequenz 40kHz
    char init1[2] = {0x6, 0x00};
    char init2[2] = {0x7, 0xff};
    i2c.write(0x40, init1, 2);
    i2c.write(0x40, init2, 2);
}

char RTC::rtc_read(char address)
{
    char value;
    i2c.start();
    //i2c.write(RTC8563_ADR_RD, &address, true);
    i2c.write(RTC8563_ADR_WR);
    i2c.write(address);
    i2c.start();
    i2c.write(RTC8563_ADR_RD);
    value = i2c.read(0);
    i2c.stop();
    return value;
}
void RTC::rtc_write(char address, char value)
{
    i2c.start();
    //i2c.write(RTC8563_ADR_WR, &address, value, true);
    i2c.write(RTC8563_ADR_WR);
    i2c.write(address);
    i2c.write(value);
    i2c.stop();
}

void RTC::rtc_init()
{
    // Format
    // 2015/03/31
    // 22:10:00

    week_val = 0x01;                // Tu
    rtc_write(CONTROL1, 0x20);      // stop
    rtc_write(CONTROL2, 0x00);
    rtc_write(YEARS, (0x15));
    rtc_write(MONTHS, (0x03));
    rtc_write(DAYS, (0x31));
    rtc_write(HOURS, (0x22));
    rtc_write(MINUTES, (0x10));
    rtc_write(SECONDS, (0x00));
    rtc_write(WEEKDAYS, week_val);
    rtc_write(CLOCKOUT_FREQ, 0x00); // 0x83 = TE on & 1Hz
    rtc_write(TIMER_CINTROL, 0x00);
    rtc_write(CONTROL1, 0x00);      // start
}

void RTC::rtc_alarm()   // Setting up RTC alarm
{
    rtc_write(CONTROL1, 0x20);      // stop
    rtc_write(CONTROL2, 0x02);      // AIE - alarm interrupt enabled
    rtc_write(DAY_ALARM, (0x80) );
    rtc_write(HOUR_ALARM, (0x97));
    rtc_write(MINUTE_ALARM, (0x02));
    rtc_write(WEEKDAY_ALARM, (0x80));
    rtc_write(CONTROL1, 0x00);      // start
}
#else

// Default constructor
RTC::RTC() 
{}
RTC::RTC(PinName sda, PinName scl) // :  i2c(sda, scl)  //_sda(sda), _scl(scl)   // no I2C default constructor
{}

char RTC::rtc_read(char address) {
    return 0x21;
}

void RTC::rtc_write(char address, char value)
{ }

void RTC::rtc_init()
{
    // Format
    // 2015/03/31
    // 22:10:00
}

void RTC::rtc_alarm()   // Setting up RTC alarm
{}
#endif

//-----------------INTERNAL USE ONLY ----------------------------
void RTC::error()
{
}