#include "Time.h"

uint8_t Time :: GetHours()
{
    uint8_t h = rtc_read(HOURS);
    return bcdToUint(h&0x3F);
}

uint8_t Time :: GetMinutes()
{
    uint8_t m = rtc_read(MINUTES);
    return bcdToUint(m&0x7F);
}

uint8_t Time :: GetSeconds()
{
    uint8_t s = rtc_read(SECONDS);
    return bcdToUint(s&0x7F);
}

uint8_t Time::bcdToUint(uint8_t const nybbles)
{
    uint8_t result;
    result = (nybbles >> 4) * 10 + (nybbles & 0x0F);
    return result;
}
