#include "Date.h"
#include "string"

/*
string Date::GetDay(uint8_t y)
{
    //return std::to_string(y); // C++ 11
    char buffer[2];
    sprintf (buffer, "%d", y);  // ToString
    return buffer;
}
*/
uint8_t Date :: GetDay()
{
    uint8_t s = rtc_read(DAYS);
    return bcdToUint(s&0x3F);
}
uint8_t Date :: GetMonth()
{
    uint8_t s = rtc_read(MONTHS);
    return bcdToUint(s&0x1F);
}

uint16_t Date :: GetYear()
{
    uint8_t y = rtc_read(YEARS);
    y = bcdToUint(y&0x3F);
    return y+2000;
}

uint8_t Date::bcdToUint(uint8_t const nybbles)
{
    uint8_t result;
    result = (nybbles >> 4) * 10 + (nybbles & 0x0F);
    return result;
}

string Date::toString(uint8_t value)
{
    //return std::to_string(value); // C++ version 11
    char buffer[2];
    sprintf (buffer, "%d", value);  // ToString()
    return buffer;
}    
    
string Date::GetDay(uint8_t y)
{
    day = "Date " + toString(y);
    return day;
}

